PyuTest.lightning_strike = function(pos, radius, size)
	local s = size or 40

	core.add_particlespawner({
		amount = 1,
		time = 0.4,

		-- make it hit the top of a block exactly with the bottom
		minpos = {x = pos.x, y = pos.y + (s / 2) + 1/2, z = pos.z },
		maxpos = {x = pos.x, y = pos.y + (s / 2) + 1/2, z = pos.z },

		minvel = {x = 0, y = 0, z = 0},
		maxvel = {x = 0, y = 0, z = 0},
		minacc = {x = 0, y = 0, z = 0},
		maxacc = {x = 0, y = 0, z = 0},
		minexptime = 0.2,
		maxexptime = 0.2,
		minsize = s * 10,
		maxsize = s * 10,
		collisiondetection = true,
		vertical = true,
		texture = "pyutest-lightning.png",
		glow = core.LIGHT_MAX,
	})

	core.sound_play("pyutest_thunder", {
		gain = 2,
		pos = pos
	})

	local r = radius or 3
	for o in core.objects_inside_radius(pos, r) do
		PyuTest.deal_damage(o, 12, PyuTest.DAMAGE_TYPES.lightning())
	end

	for x = -r, r do
		for z = -r, r do
			local y_pos

			if core.get_node(pos).name ~= "air" then
				y_pos = pos.y + 1
			elseif core.get_node(pos - vector.new(0, 1, 0)).name ~= "air" then
				y_pos = pos.y
			end

			if y_pos then
				local npos = vector.new(pos.x + x, y_pos, pos.z +z)
				local b = core.get_node(npos).name == "air"
				local b2 = core.get_node(npos - vector.new(0, 1, 0)).name ~= "air"
				if math.random(1, 6) == 1 and b and b2 then
					core.set_node(npos, {name = "pyutest_blocks:fire"})
				end
			end
		end
	end
end
