local class = {
	_owner = nil,
	_collided = false
}

function class:on_step(dtime, moveresult)
	local slowdown_speed = self._slowdown_speed or 0.98
	local slowdown = self._slowdown

	if slowdown == nil then
		slowdown = true
	end

	if slowdown then
		local vel = self.object:get_velocity()
		vel = vector.multiply(vel, slowdown_speed)
		self.object:set_velocity(vel)
	end

	for _, v in pairs(moveresult.collisions) do
		if v.type == "node" then
			self._collided = true
			self:_on_hit_node(v.node_pos, core.get_node(v.node_pos))
		elseif v.type == "object" and v.object ~= self._owner then
			self._collided = true
			self:_on_hit_object(v.object)
		end
	end

	if self._collided then
		self.object:remove()
	end
end

PyuTest.make_projectile = function (name, properties, options, functions)
	local fns = functions or {}

	fns.on_hit_node = fns.on_hit_node or function (...)end
	fns.on_hit_object = fns.on_hit_object or function (...)end

	core.register_entity(name, setmetatable(PyuTest.util.tableconcat({
		initial_properties = PyuTest.util.tableconcat({
			visual = "cube",
			visual_size = {x=0.5, y=0.5},
			collisionbox = {-0.2, -0.2, -0.2, 0.2, 0.2, 0.2},
			use_texture_alpha = false,
			pointable = false,
			glow = core.LIGHT_MAX,
			physical = true,
			collide_with_objects = true,
		}, properties or {}),

		_on_hit_node = fns.on_hit_node,
		_on_hit_object = fns.on_hit_object
	}, options or {}), { __index = class }))
end

PyuTest.shoot_projectile_from_object = function(name, object, velocity)
	local pos = object:get_pos()
	pos = vector.offset(pos, 0, 1.3, 0)

	local pvel = velocity or 30

	if object:is_player() then
		local dir = object:get_look_dir()

		pos = vector.add(pos, dir)

		local projectile = core.add_entity(pos, name)
		projectile:set_velocity(vector.multiply(dir, pvel))
		projectile:set_rotation(dir)
		projectile:get_luaentity()._owner = object

		return projectile
	else
		local projectile = core.add_entity(pos, name)

		-- TODO

		return projectile
	end
end
