local modpath = core.get_modpath(core.get_current_modname())

dofile(modpath .. "/api.lua")
dofile(modpath .. "/projectiles/snowball.lua")

PyuTest.make_projectile("pyutest_projectiles:fireball", {
	visual = "sprite",
	visual_size = {x = 1.4, y = 1.4},
	textures = {
		"pyutest-fireball.png",
	}
}, {
	_slowdown = false
}, {
	on_hit_node = function (self, pos, node)
		PyuTest.create_explosion(pos, 3, false, 12)
	end,
	on_hit_object = function (self, object)
		PyuTest.create_explosion(object:get_pos(), 3, false, 12)
	end
})

PyuTest.make_projectile("pyutest_projectiles:arrow", {
	visual = "upright_sprite",
	visual_size = {x = 0.4, y = 0.4},
	textures = {
		"pyutest-arrow.png",
		"pyutest-arrow.png",
	}
}, {
	_slowdown = false
}, {
	on_hit_node = function (self, pos, node)
	end,
	on_hit_object = function (self, object)
		PyuTest.deal_damage(object, 6, PyuTest.DAMAGE_TYPES.shot("Arrow"))
	end
})
