-- from https://git.minetest.land/VoxeLibre/VoxeLibre/src/branch/master/mods/ITEMS/mcl_cauldrons/init.lua#L20
local node_box = {
	type = "fixed",
	fixed = {
		{-0.5, -0.1875, -0.5, -0.375, 0.5, 0.5}, -- Left wall
		{0.375, -0.1875, -0.5, 0.5, 0.5, 0.5}, -- Right wall
		{-0.375, -0.1875, 0.375, 0.375, 0.5, 0.5}, -- Back wall
		{-0.375, -0.1875, -0.5, 0.375, 0.5, -0.375}, -- Front wall
		{-0.5, -0.3125, -0.5, 0.5, -0.1875, 0.5}, -- Floor
		{-0.5, -0.5, -0.5, -0.375, -0.3125, -0.25}, -- Left front foot, part 1
		{-0.375, -0.5, -0.5, -0.25, -0.3125, -0.375}, -- Left front foot, part 2
		{-0.5, -0.5, 0.25, -0.375, -0.3125, 0.5}, -- Left back foot, part 1
		{-0.375, -0.5, 0.375, -0.25, -0.3125, 0.5}, -- Left back foot, part 2
		{0.375, -0.5, 0.25, 0.5, -0.3125, 0.5}, -- Right back foot, part 1
		{0.25, -0.5, 0.375, 0.375, -0.3125, 0.5}, -- Right back foot, part 2
		{0.375, -0.5, -0.5, 0.5, -0.3125, -0.25}, -- Right front foot, part 1
		{0.25, -0.5, -0.5, 0.375, -0.3125, -0.375}, -- Right front foot, part 2
	}
}

local function cauldron_formspec(pos)
	local spos = string.format("%d,%d,%d", pos.x, pos.y, pos.z)

	local formspec = {
		"size[8,9]",
		"list[nodemeta:", spos, ";main;0,0;8,4;]",
		"list[context;src;1,1;1,1;]",
		"list[context;fuel;1,2.5;1,1;]",
		"list[context;dst;5,1.25;2,2;]",
		"button[2,3.5;4,2;brew;Brew]",
		"list[current_player;main;0,5;8,4;]"
	}

	return table.concat(formspec)
end

local function on_construct(pos)
	local meta = core.get_meta(pos)
	local inventory = meta:get_inventory()
	inventory:set_size("src", 1)
	inventory:set_size("fuel", 1)
	inventory:set_size("dst", 4)
	meta:set_string("formspec", cauldron_formspec(pos))
end

local function on_destruct(pos)
	local drops = {}
	PyuTest.get_inventory_drops(pos, "src", drops)
	PyuTest.get_inventory_drops(pos, "fuel", drops)
	PyuTest.get_inventory_drops(pos, "dst", drops)

	for _, v in pairs(drops) do
		core.add_item(pos, v)
	end
end

local function on_receive_fields(pos, formname, fields, player)
	if fields.quit then return end

	local meta = core.get_meta(pos)
	local inv = meta:get_inventory()

	if fields.brew then
		local src = inv:get_stack("src", 1)
		local fuel = inv:get_stack("fuel", 1)

		if core.get_item_group(fuel:get_name(), "brewing_fuel") == 0 then
			return
		end

		local output = PyuTest.potion_recipes[src:get_name()]

		if output == nil then
			return	
		end

		inv:add_item("dst", output)
		src:take_item()
		fuel:take_item()
		inv:set_stack("src", 1, src)
		inv:set_stack("fuel", 1, fuel)
	end
end

PyuTest.make_node("pyutest_potions:cauldron", "Cauldron", {
	cracky = PyuTest.BLOCK_NORMAL,
	cauldron = 1,
}, {"pyutest-metal.png"}, {
	drawtype = "nodebox",
	paramtype = "light",
	node_box = node_box,
	on_construct = on_construct,
	on_destruct = on_destruct,
	on_receive_fields = on_receive_fields
})

core.register_craft({
	output = "pyutest_potions:cauldron",
	recipe = {
		{"pyutest_ores:iron_ingot", "", "pyutest_ores:iron_ingot"},
		{"pyutest_ores:iron_ingot", "", "pyutest_ores:iron_ingot"},
		{"pyutest_ores:iron_ingot", "pyutest_ores:iron_ingot", "pyutest_ores:iron_ingot"},
	}
})
