local modpath = core.get_modpath("pyutest_entities")
dofile(modpath .. "/api.lua")

PyuTest.make_mob("pyutest_entities:test_follower", {
	visual = "upright_sprite",
	visual_size = { x = 1, y = 2 },
	makes_footstep_sound = true,
	textures = {
		"pyutest-monster.png", "pyutest-monster_back.png"
	},
	nametag = "Test Follower",
}, {
	follow_player = true,
	max_jump = 1,
	max_drop = 50,
	view_range = 5,

	drops = {
		"pyutest_tools:apple 5"
	}
})

PyuTest.make_mob("pyutest_entities:monster", {
	visual = "upright_sprite",
	visual_size = { x = 1, y = 2 },
	makes_footstep_sound = true,
	textures = {
		"pyutest-monster.png", "pyutest-monster_back.png"
	},
	nametag = "Monster",
}, {
	follow_player = true,
	hit_damage = 3,
	max_jump = 1,
	max_drop = 50,
	view_range = 10,

	drops = {
		"pyutest_tools:bone 2"
	},

	attack_entities = {
		"player"
	},
	attack_type = "melee",
})

PyuTest.make_mob("pyutest_entities:dummy", {
	visual = "upright_sprite",
	visual_size = { x = 1, y = 2 },
	makes_footstep_sound = true,
	textures = {
		"player.png", "player_back.png"
	},
	nametag = "Dummy",
}, {
	drops = {
		"pyutest_tools:apple 3",
		"pyutest_ores:diamond_shard 3",
		"pyutest_ores:emerald_shard 3",
		"pyutest_magic:windball 3"
	}
})

PyuTest.make_mob("pyutest_entities:item_follower", {
	visual = "upright_sprite",
	visual_size = { x = 1, y = 2 },
	makes_footstep_sound = true,
	textures = {
		"player.png^[brighten", "player_back.png^[brighten"
	},
	nametag = "Item Follower",
}, {
	drops = {},
	follow_items = {
		"pyutest_tools:coin"
	}
})

PyuTest.make_mob("pyutest_entities:pig", {
	hp_max = 10,
	visual = "upright_sprite",
	visual_size = {x = 1, y = 1},
	textures = {"pyutest-pig.png", "pyutest-pig-back.png"},
	nametag = "Pig",
	collisionbox = PyuTest.SMALL_ANIMAL_CBOX,
}, {
	drops = {
		"pyutest_tools:raw_pork 3"
	},
	follow_items = {
		"pyutest_tools:carrot"
	}
})
