PyuTest.make_stairs = function(name, desc, craftitem, texture, groups, extra)
	local e = extra or {}
	local id_inner = name .. "_inner"
	local id_outer = name .. "_outer"

	core.register_node(name, PyuTest.util.tableconcat({
		description = Translate(desc),
		groups = PyuTest.util.tableconcat(groups, {
			block = 1,
			slab = 1,
		}),
		tiles = texture,
		sounds = PyuTest.make_node_sounds(),
		paramtype = "light",
		paramtype2 = "colorfacedir",

		drawtype = "nodebox",
		node_box = PyuTest.NODE_BOXES.STAIRS,
		on_place = PyuTest.rotate_and_place,
	}, e))

	core.register_node(id_inner, PyuTest.util.tableconcat({
		description = Translate("Inner " .. desc),
		groups = PyuTest.util.tableconcat(groups, {
			block = 1,
			slab = 1,
		}),
		tiles = texture,
		sounds = PyuTest.make_node_sounds(),
		paramtype = "light",
		paramtype2 = "colorfacedir",

		drawtype = "nodebox",
		node_box = {
			type = "fixed",
			fixed = {
				{-0.5, -0.5, -0.5, 0.5, 0.0, 0.5},
				{-0.5, 0.0, 0.0, 0.5, 0.5, 0.5},
				{-0.5, 0.0, -0.5, 0.0, 0.5, 0.0},
			},
		},
		on_place = PyuTest.rotate_and_place,
	}, e))

	core.register_node(id_outer, PyuTest.util.tableconcat({
		description = Translate("Outer " .. desc),
		groups = PyuTest.util.tableconcat(groups, {
			block = 1,
			slab = 1,
		}),
		tiles = texture,
		sounds = PyuTest.make_node_sounds(),
		paramtype = "light",
		paramtype2 = "colorfacedir",

		drawtype = "nodebox",
		node_box = {
			type = "fixed",
			fixed = {
				{-0.5, -0.5, -0.5, 0.5, 0.0, 0.5},
				{-0.5, 0.0, 0.0, 0.0, 0.5, 0.5},
			},
		},
		on_place = PyuTest.rotate_and_place,
	}, e))

	if craftitem ~= nil then
		core.register_craft({
			output = name .. " 4",
			recipe = {
				{ craftitem, "",       "" },
				{ craftitem, craftitem, "" },
				{ craftitem, craftitem, craftitem }
			}
		})

		core.register_craft({
			output = id_inner,
			recipe = {
				name
			},
			type = "shapeless"
		})

		core.register_craft({
			output = id_outer,
			recipe = {
				id_inner
			},
			type = "shapeless"
		})
	end
end

PyuTest.make_slab = function(name, desc, craftitem, texture, groups, extra)
	local e = extra or {}

	core.register_node(name, PyuTest.util.tableconcat({
		description = Translate(desc),
		groups = PyuTest.util.tableconcat(groups, {
			block = 1,
			slab = 1,
		}),
		tiles = texture,
		sounds = PyuTest.make_node_sounds(),
		paramtype = "light",
		paramtype2 = "colorfacedir",

		drawtype = "nodebox",
		node_box = {
			type = "fixed",
			fixed = {-0.5, -0.5, -0.5, 0.5, 0, 0.5},
		},
		on_place = function (itemstack, placer, pointed_thing)
			return PyuTest.rotate_and_place(itemstack, placer, pointed_thing)
		end
	}, e))

	if craftitem ~= nil then
		core.register_craft({
			output = name .. " 6",
			recipe = {
				{ craftitem, craftitem, craftitem }
			}
		})
	end
end
