PyuTest.make_ore_and_item("pyutest_mithril:mithril", "Mithril", "shard", "Shard", {
	ore_options = {
		scarcity = 23 * 23 * 23,
		y_max = PyuTest.IceWorld.y_max,
		y_min = PyuTest.IceWorld.y_min,
		wherein = {"group:ice"},

		ore_strength = PyuTest.BLOCK_SLOW,
		ore_color = "#5e47b7",
		ore_stone = {"pyutest-ice.png"}
	},

	item_texture = "pyutest-shard.png",
	item_conf = {
		color = "#5e47b7"
	},

	block_tiles = { "pyutest-metal.png" },
	block_color = "#5e47b7",
	block_shiny = true,
})

PyuTest.make_tool("pyutest_mithril:mithril_pickaxe", "Mithril Pickaxe", {
	pickaxe = 1
}, "pyutest-mithril-pickaxe.png", {
	stack_max = 1,
	tool_capabilities = PyuTest.tool_caps({
		uses = 5536,
		attack_uses = 5536 / 2,
		groupcaps = {
			cracky = {
				times = {
					[PyuTest.BLOCK_FAST] = 0.1,
					[PyuTest.BLOCK_NORMAL] = 0.2,
					[PyuTest.BLOCK_SLOW] = 0.4
				}
			},

			crumbly = {
				times = {
					[PyuTest.BLOCK_FAST] = 0.2,
					[PyuTest.BLOCK_NORMAL] = 0.2,
					[PyuTest.BLOCK_SLOW] = 0.4,
				}
			}
		}
	}),
})

core.register_craft({
	output = "pyutest_mithril:mithril_pickaxe",
	recipe = {
		{ "pyutest_mithril:mithril_shard", "pyutest_mithril:mithril_shard", "pyutest_mithril:mithril_shard" },
		{ "",                              "pyutest_tools:basalt_stick",           "" },
		{ "",                              "pyutest_tools:basalt_stick",           "" }
	}
})

PyuTest.make_tool("pyutest_mithril:mithril_axe", "Mithril Axe", {
	axe = 1
}, "pyutest-mithril-axe.png", {
	stack_max = 1,
	tool_capabilities = PyuTest.tool_caps({
		uses = 5536,
		attack_uses = 5536,
		damage_groups = { fleshy = 12 },
		groupcaps = {
			choppy = {
				times = {
					[PyuTest.BLOCK_FAST] = 0.1,
					[PyuTest.BLOCK_NORMAL] = 0.2,
					[PyuTest.BLOCK_SLOW] = 0.4
				}
			}
		}
	})
})

core.register_craft({
	output = "pyutest_mithril:mithril_axe",
	recipe = {
		{ "pyutest_mithril:mithril_shard", "pyutest_mithril:mithril_shard", "" },
		{ "pyutest_mithril:mithril_shard", "pyutest_tools:basalt_stick",           "" },
		{ "",                              "pyutest_tools:basalt_stick",           "" }
	}
})

PyuTest.make_sword("pyutest_mithril:mithril_sword", "Mithril Sword", "pyutest-mithril-sword.png", 11, 5536, 0.55)

core.register_craft({
	output = "pyutest_mithril:mithril_sword",
	recipe = {
		{ "pyutest_mithril:mithril_shard" },
		{ "pyutest_mithril:mithril_shard" },
		{ "pyutest_tools:basalt_stick" }
	}
})
