PyuTest.potion_recipes = {}

PyuTest.make_potion = function (name, desc, options)
	local colorspec = core.colorspec_to_colorstring(options.color or "red")
	local texture = string.format("pyutest-glass-bottle.png^(pyutest-bottle-overlay.png^[colorize:%s)", colorspec)
	local ptexture = string.format("pyutest-snowball-particle.png^[colorize:%s", colorspec)

	local l = options.length or 60
	local m = options.multiplier or 1.15
	local e_id = name .. "_splash"

	if options.craft ~= nil then
		PyuTest.potion_recipes[options.craft] = name
	end

	PyuTest.make_projectile(e_id, {
		visual = "sprite",
		textures = {texture},
	}, {
		_slowdown = false,
	}, {
		on_hit_node = function (self, pos, node)
			splash(pos + vector.new(0, 1, 0))
		end,
		on_hit_object = function (self, object)
			splash(self.object:get_pos(), self.object)
		end
	})

	local function drink(itemstack, user, pointed_thing)
		if user == nil or not user:is_player() then
			return
		end

		if options.action then
			options.action(itemstack, user, pointed_thing)
		else
			local playername = user:get_player_name()
			PyuTest.status_effect_add(playername, options.effect, m, l)
		end

		itemstack:take_item()
		return itemstack
	end

	local function splash(pos, obj)
		local rad = options.radius or 2
		for o in core.objects_inside_radius(pos, rad) do
			if o ~= obj then
				if o:is_player() then
					if options.action_splash then
						options.action_splash(o)
					else
						local playername = o:get_player_name()
						PyuTest.status_effect_add(playername, options.effect, m, l)
					end
				end
			end
		end

		local vel = 2
		core.add_particlespawner({
			amount = math.random(5, 10),
			time = 0.8,
			exptime = 0.4,
			vertical = true,
			glow = core.LIGHT_MAX,
			minsize = 1.3,
			maxsize = 1.3,

			texture = ptexture,
			pos = pos,
			minvel = vector.new(-vel, -vel, -vel),
			maxvel = vector.new(vel, vel, vel),
		})
	end

	local function launch(itemstack, user, pointed_thing)
		core.sound_play("pyutest-throw", {
			player = user:get_player_name()
		})
		PyuTest.shoot_projectile_from_object(e_id, user)

		itemstack:take_item()
		return itemstack
	end

	PyuTest.make_item(name, desc, {
		potion = 1
	}, texture, {
		on_use = drink,
		on_place = launch,
		on_secondary_use = launch
	})
end
