local modpath = core.get_modpath(core.get_current_modname())
dofile(modpath .. "/api.lua")

core.register_ore({
	ore_type = "blob",
	ore = "pyutest_blocks:granite_block",
	wherein = "pyutest_blocks:stone_block",
	clust_scarcity = 9 * 9 * 9,
	clust_num_ores = 35,
	clust_size = 5,
	y_max = PyuTest.OVERWORLD_SURFACE_BOTTOM - 1,
	y_min = PyuTest.OVERWORLD_BOTTOM,
	noise_params = PyuTest.SPECIAL_STONE_NOISE_PARAMS
})

core.register_ore({
	ore_type = "blob",
	ore = "pyutest_blocks:andesite_block",
	wherein = "pyutest_blocks:stone_block",
	clust_scarcity = 9 * 9 * 9,
	clust_num_ores = 35,
	clust_size = 5,
	y_max = PyuTest.OVERWORLD_SURFACE_BOTTOM - 1,
	y_min = PyuTest.OVERWORLD_BOTTOM,
	noise_params = PyuTest.SPECIAL_STONE_NOISE_PARAMS
})

core.register_ore({
	ore_type = "blob",
	ore = "pyutest_blocks:diorite_block",
	wherein = "pyutest_blocks:stone_block",
	clust_scarcity = 9 * 9 * 9,
	clust_num_ores = 35,
	clust_size = 5,
	y_max = PyuTest.OVERWORLD_SURFACE_BOTTOM - 1,
	y_min = PyuTest.OVERWORLD_BOTTOM,
	noise_params = PyuTest.SPECIAL_STONE_NOISE_PARAMS
})

core.register_ore({
	ore_type = "blob",
	ore = "pyutest_blocks:tuff_block",
	wherein = "pyutest_blocks:stone_block",
	clust_scarcity = 9 * 9 * 9,
	clust_num_ores = 35,
	clust_size = 5,
	y_max = PyuTest.OVERWORLD_SURFACE_BOTTOM - 1,
	y_min = PyuTest.OVERWORLD_BOTTOM,
	noise_params = PyuTest.SPECIAL_STONE_NOISE_PARAMS
})

core.register_ore({
	ore_type = "blob",
	ore = "pyutest_blocks:clay_block",
	wherein = "pyutest_blocks:gravel_block",
	clust_scarcity = 7 * 7 * 7,
	clust_num_ores = 35,
	clust_size = 5,
	y_max = PyuTest.OVERWORLD_SURFACE_BOTTOM - 1,
	y_min = PyuTest.OVERWORLD_DEEP_OCEAN_MIN,
	noise_params = PyuTest.SPECIAL_STONE_NOISE_PARAMS
})

PyuTest.ORE_STONES = {
	"pyutest_blocks:stone_block",
	"pyutest_blocks:granite_block",
	"pyutest_blocks:andesite_block",
	"pyutest_blocks:diorite_block",
	"pyutest_blocks:tuff_block",
	"pyutest_blocks:calcite_block",
	"pyutest_blocks:darkstone_block"
}

core.register_ore({
	ore_type = "blob",
	ore = "pyutest_blocks:dirt",
	wherein = "pyutest_blocks:stone_block",
	clust_scarcity = 7 * 7 * 7,
	clust_num_ores = 35,
	clust_size = 5,
	y_max = PyuTest.OVERWORLD_SURFACE_BOTTOM - 1,
	y_min = PyuTest.OVERWORLD_BOTTOM,
	noise_params = PyuTest.SPECIAL_STONE_NOISE_PARAMS
})

-- Overworld ores
PyuTest.make_ore_and_item("pyutest_ores:coal", "Coal", "lump", "Lump", {
	ore_options = {
		scarcity = 8 * 8 * 8,
		y_max = 48,
		wherein = PyuTest.ORE_STONES,

		ore_strength = PyuTest.BLOCK_NORMAL,
		ore_drop_count = 2,
		ore_color = { r = 32, g = 32, b = 32 },
	},

	item_texture = "pyutest-lump.png",
	item_conf = {
		color = { r = 32, g = 32, b = 32 }
	},
	item_groups = {
		fuel = 1
	},

	block_tiles = { "pyutest-metal.png" },
	block_color = { r = 32, g = 32, b = 32 }
})

PyuTest.make_ore_and_item("pyutest_ores:iron", "Iron", "ingot", "Ingot", {
	ore_options = {
		scarcity = 11 * 11 * 11,
		y_max = 18,
		wherein = PyuTest.ORE_STONES,

		ore_strength = PyuTest.BLOCK_NORMAL,
	},

	item_texture = "pyutest-ingot.png",

	make_raw = true,
	raw_texture = "pyutest-lump.png",

	block_tiles = { "pyutest-metal.png" },
})

PyuTest.make_ore_and_item("pyutest_ores:zinc", "Zinc", "ingot", "Ingot", {
	ore_options = {
		scarcity = 11 * 11 * 11,
		y_max = 18,
		wherein = PyuTest.ORE_STONES,

		ore_strength = PyuTest.BLOCK_NORMAL,
		ore_color = "#bed3d4",
	},

	item_texture = "pyutest-ingot.png",
	item_conf = {
		color = "#bed3d4"
	},

	make_raw = true,
	raw_texture = "pyutest-lump.png",
	raw_conf = {
		color = "#bed3d4"
	},

	block_tiles = { "pyutest-metal.png" },
	block_color = "#bed3d4"
})

PyuTest.make_ore_and_item("pyutest_ores:copper", "Copper", "ingot", "Ingot", {
	ore_options = {
		scarcity = 11 * 11 * 11,
		y_max = 18,
		wherein = PyuTest.ORE_STONES,

		ore_strength = PyuTest.BLOCK_NORMAL,
		ore_color = "darkgoldenrod",
	},

	item_texture = "pyutest-ingot.png",
	item_conf = {
		color = "darkgoldenrod",
	},

	make_raw = true,
	raw_texture = "pyutest-lump.png",
	raw_conf = {
		color = "darkgoldenrod"
	},

	block_tiles = { "pyutest-metal.png" },
	block_color = "darkgoldenrod"
})

PyuTest.make_ore_and_item("pyutest_ores:tin", "Tin", "ingot", "Ingot", {
	ore_options = {
		scarcity = 11 * 11 * 11,
		y_max = 18,
		wherein = PyuTest.ORE_STONES,

		ore_strength = PyuTest.BLOCK_NORMAL,
		ore_color = "#686569",
	},

	item_texture = "pyutest-ingot.png",
	item_conf = {
		color = "#686569"
	},

	make_raw = true,
	raw_texture = "pyutest-lump.png",
	raw_conf = {
		color = "#686569"
	},

	block_tiles = { "pyutest-metal.png" },
	block_color = "#686569"
})

PyuTest.make_ore_and_item("pyutest_ores:gold", "Gold", "ingot", "Ingot", {
	ore_options = {
		scarcity = 15.5 * 15.5 * 15.5,
		y_max = -35,
		wherein = PyuTest.ORE_STONES,

		ore_strength = PyuTest.BLOCK_NORMAL,
		ore_color = "gold",
	},

	item_texture = "pyutest-ingot.png",
	item_conf = {
		color = "gold"
	},

	make_raw = true,
	raw_texture = "pyutest-lump.png",
	raw_conf = {
		color = "gold"
	},

	block_tiles = { "pyutest-metal.png" },
	block_color = "gold",
	block_shiny = true,
})

PyuTest.make_ore_and_item("pyutest_ores:ruby", "Ruby", "shard", "Shard", {
	ore_options = {
		scarcity = 15.5 * 15.5 * 15.5,
		y_max = -35,
		wherein = PyuTest.ORE_STONES,

		ore_strength = PyuTest.BLOCK_NORMAL,
		ore_color = "red",
	},

	item_texture = "pyutest-shard.png",
	item_conf = {
		color = "red"
	},

	block_tiles = { "pyutest-metal.png" },
	block_color = "red",
	block_shiny = true,
})

PyuTest.make_ore_and_item("pyutest_ores:diamond", "Diamond", "shard", "Shard", {
	ore_options = {
		scarcity = 16.7 * 16.7 * 16.7,
		y_max = -50,
		wherein = PyuTest.ORE_STONES,

		ore_strength = PyuTest.BLOCK_NORMAL,
		ore_color = "cyan",
	},

	item_texture = "pyutest-shard.png",
	item_conf = {
		color = "cyan"
	},

	block_tiles = { "pyutest-metal.png" },
	block_color = "cyan",
	block_shiny = true,
})

PyuTest.make_ore_and_item("pyutest_ores:emerald", "Emerald", "shard", "Shard", {
	ore_options = {
		scarcity = 18.3 * 18.3 * 18.3,
		y_max = -50,
		wherein = PyuTest.ORE_STONES,

		ore_strength = PyuTest.BLOCK_NORMAL,
		ore_color = "seagreen",
	},

	item_texture = "pyutest-shard.png",
	item_conf = {
		color = "seagreen"
	},

	block_tiles = { "pyutest-metal.png" },
	block_color = "seagreen",
	block_shiny = true,
})
