local function do_particles(pos)
	local vel = 0.5

	core.add_particlespawner({
		amount = math.random(5, 10),
		time = 0.8,
		exptime = 0.3,
		vertical = true,
		glow = core.LIGHT_MAX,

		-- collisiondetection = true,
		-- texture = "pyutest-snowball-particle.png",
		pos = pos,
		node = {name = "pyutest_blocks:snow"},
		-- minvel = vector.new(-vel, -vel, -vel),
		-- maxvel = vector.new(vel, vel, vel),
	})
end

PyuTest.make_projectile("pyutest_projectiles:snowball", {
	visual = "sprite",
	visual_size = {x = 1, y = 1},
	textures = {
		"pyutest-snowball.png",
	}
}, {
	_slowdown = false,
}, {
	on_hit_node = function (self, pos, node)
		do_particles(pos + vector.new(0, 1, 0))
	end,
	on_hit_object = function (self, object)
		do_particles(self.object:get_pos())
		PyuTest.deal_damage(object, 1, PyuTest.DAMAGE_TYPES.shot("Snowball"))
	end
})
