PyuTest.make_leaves = function(id, desc, color, overlay, special_drops, drops)
	local leaves_id = id .. "_leaves"

	core.register_alias(leaves_id.."_block", leaves_id)
	PyuTest.make_node(leaves_id, desc .. " Leaves", {
		acid_vulnerable = 1,
		flammable = 1,
		snappy = PyuTest.BLOCK_FAST,
		block = 1
	}, { { name = "pyutest-leaves.png", color = color } }, {
		drawtype = "allfaces_optional",
		waving = 2,
		paramtype = "light",
		walkable = false,
		sunlight_propagates = true,
		is_ground_content = false,
		overlay_tiles = { overlay },
		_pyutest_blast_resistance = 0
	})
	if special_drops == nil or special_drops == true then
		core.override_item(leaves_id, {
			drop = drops or {
				max_items = 1,
				items = {
					{
						tool_groups = {
							"shears"
						},
						items = { leaves_id }
					},

					{
						rarity = 2.2,
						items = { "pyutest_tools:apple" }
					},

					{
						rarity = 2.2,
						items = { "pyutest_tools:banana" }
					},

					{
						rarity = 2.2,
						items = { "pyutest_tools:stick 2" }
					},

					{
						rarity = 1.6,
						items = { "pyutest_tools:stick 1" }
					}
				}
			}
		})
	end
end

PyuTest.make_leaves("pyutest_leaves:oak", "Oak", "#749752")
PyuTest.make_leaves("pyutest_leaves:snowy", "Snowy")
PyuTest.make_leaves("pyutest_leaves:cherry", "Cherry", "#f3c2db")
PyuTest.make_leaves("pyutest_leaves:dark", "Dark", "#395124")
PyuTest.make_leaves("pyutest_leaves:aspen", "Aspen", "#978c52")
PyuTest.make_leaves("pyutest_leaves:red_aspen", "Red Aspen", "#945c53")
PyuTest.make_leaves("pyutest_leaves:ominous", "Ominous", "#3e3245")
