PyuTest.make_wand = function (id, desc, texture, mana, properties, fns)
	local e_id = id .. "_projectile"

	PyuTest.make_projectile(e_id, properties, {
		_slowdown = false
	}, {
		on_hit_node = fns.on_hit_node,
		on_hit_object = fns.on_hit_object
	})

	PyuTest.make_item(id, desc, {
		wand = 1
	}, texture, {
		stack_max = 1,
		on_use = function (itemstack, user, pointed_thing)
			if not user:is_player() then return itemstack end
			if not PyuTest.use_mana(user:get_player_name(), mana) then
				return
			end

			PyuTest.shoot_projectile_from_object(e_id, user)
			
			core.sound_play("pyutest_magic_action", {
				gain = 1,
				pos = pos
			})

			return itemstack
		end
	})
end

PyuTest.make_wand("pyutest_magic:ice_wand", "Ice Wand", "pyutest-ice-wand.png", 20, {
	textures = {
		"pyutest-ice.png",
		"pyutest-ice.png",
		"pyutest-ice.png",
		"pyutest-ice.png",
		"pyutest-ice.png",
		"pyutest-ice.png",
	}
}, {
	on_hit_node = function (self, pos, node)
		for e in core.objects_inside_radius(pos, 2) do
			if e ~= self._owner then
				PyuTest.deal_damage(e, 6, PyuTest.DAMAGE_TYPES.freezing())
			end
		end

		PyuTest.dorange(pos, 1, function (p)
			local n = core.get_node(p)

			if n.name ~= "air" then
				if math.random(1, 3) == 1 then
					core.set_node(p, {name = "pyutest_blocks:snow_block"})
				else
					core.set_node(p, {name = "pyutest_blocks:ice_block"})
				end

				core.after(math.random(7, 13), function ()
					core.set_node(p, {name = n.name, param1 = n.param1, param2 = n.param2})
				end)
			end
		end)
	end
})

PyuTest.make_wand("pyutest_magic:fire_wand", "Fire Wand", "pyutest-fire-wand.png", 20, {
	textures = {
		"pyutest-lava.png",
		"pyutest-lava.png",
		"pyutest-lava.png",
		"pyutest-lava.png",
		"pyutest-lava.png",
		"pyutest-lava.png",
	}
}, {
	on_hit_node = function (self, pos, node)
		-- TODO: Fix behaviour
		PyuTest.dorange(self.object:get_pos(), 1, function (p)
			local node = core.get_node(p)
			local walkable = core.registered_nodes[node.name].walkable

			if not walkable then
				if math.random(1, 4) ~= 1 then
					core.set_node(p, {name = "pyutest_blocks:fire"})
				end
			else
				core.set_node(p, {name = "pyutest_blocks:molten_rock"})
			end
		end)
	end
})

PyuTest.make_wand("pyutest_magic:arcane_wand", "Arcane Wand", "pyutest-arcane-wand.png", 33, {
	textures = {
		"pyutest-crystal-lantern.png",
		"pyutest-crystal-lantern.png",
		"pyutest-crystal-lantern.png",
		"pyutest-crystal-lantern.png",
		"pyutest-crystal-lantern.png",
		"pyutest-crystal-lantern.png",
	}
}, {
	on_hit_node = function (self, pos, node)
		PyuTest.lightning_strike(self.object:get_pos(), 3)
	end,
	on_hit_object = function(self, object)
		PyuTest.deal_damage(object, 9, PyuTest.DAMAGE_TYPES.lightning())
	end
})

PyuTest.make_wand("pyutest_magic:teleportation_wand", "Teleportation Wand",
"pyutest-teleportation-wand.png", 40, {
	textures = {
		"pyutest-crystal-lantern.png",
		"pyutest-crystal-lantern.png",
		"pyutest-crystal-lantern.png",
		"pyutest-crystal-lantern.png",
		"pyutest-crystal-lantern.png",
		"pyutest-crystal-lantern.png",
	}
}, {
	on_hit_node = function (self, pos, node)
		if self._owner ~= nil then
			self._owner:set_pos(self.object:get_pos())
		end
	end,
	on_hit_object = function(self, object)
		if self._owner ~= nil then
			object:set_pos(self._owner:get_pos())
		end
	end
})

PyuTest.make_wand("pyutest_magic:explosions_wand", "Explosions Wand",
"pyutest-explosions-wand.png", 33, {
	textures = {
		"pyutest-tnt-top-bottom.png",
		"pyutest-tnt-top-bottom.png",
		"pyutest-tnt-side.png",
		"pyutest-tnt-side.png",
		"pyutest-tnt-side.png",
		"pyutest-tnt-side.png",
	}
}, {
	on_hit_node = function(self, pos, node)
		PyuTest.create_explosion(pos, 2, false, 10, {self._owner}, 4)
	end,
	on_hit_object = function(self, object)
		PyuTest.create_explosion(object:get_pos(), 2, false, 10, {self._owner}, 4)
	end
})
