local modpath = core.get_modpath("pyutest_cmds")
dofile(modpath .. "/api.lua")


core.register_chatcommand("say", {
	params = "<text>",
	description = [[Say <text>
	There are some text replacement macros you can use.
	Here is a list of them:
	- %n: Replaced with your username
	- %r: Replaced with some random player's name]],
	func = function(name, param)
		local str = param
		str = str:gsub("%%n", name)
		str = str:gsub("%%r", function ()
			return PyuTest.chatcommand_entity_selector(name, "@r")[1]
		end)
		str = PyuTest.parse_command_functions(name, str)

		core.chat_send_all(str)
	end
})

core.register_chatcommand("getpos", {
	params = "<player>",
	description = "Return the position of <player>",
	func = function(name, param)
		local target = PyuTest.chatcommand_entity_selector(name, param)
		local player = core.get_player_by_name(target[1])

		if not player then
			return ""
		end
		local pos = player:get_pos()

		return string.format("%f %f %f", pos.x, pos.y, pos.z)
	end
})

core.register_chatcommand("kill", {
	params = "<player>",
	description = "Kill <player>",
	privs = {
		server = true
	},
	func = function (name, param)
		local targets = PyuTest.chatcommand_entity_selector(name, param)
		for _, v in pairs(targets) do
			if not core.get_player_by_name(v) then
				core.chat_send_player(name, "Invalid player: " .. v)
				return
			end
		end

		for _, v in pairs(targets) do
			local plr = core.get_player_by_name(v)
			PyuTest.deal_damage(plr, plr:get_hp(), PyuTest.DAMAGE_TYPES.magic())
		end
	end
})

core.register_chatcommand("teleport", {
	params = "<player> <x> <y> <z>",
	description = "Teleport <player> to <x> <y> <z>",
	privs = {teleport = true},
	func = function(name, param)
		local found, _, player, x, y, z = PyuTest.parse_command_functions(name, param)
		:find("^([^%s]+)%s+([^%s]+)%s+([^%s]+)%s+([^%s]+)$")

		if found == nil then
			core.chat_send_player(name, "Invalid usage: " .. param)
			return
		end

		local targets = PyuTest.chatcommand_entity_selector(name, player)
		for _, v in pairs(targets) do
			if not core.get_player_by_name(v) then
				core.chat_send_player(name, "Invalid player: " .. v)
				return
			end
		end

		local caller = core.get_player_by_name(name)
		for _, v in pairs(targets) do
			local plr = core.get_player_by_name(v)
			local pos = caller:get_pos()

			local nx = core.parse_relative_number(x, pos.x)
			local ny = core.parse_relative_number(y, pos.y)
			local nz = core.parse_relative_number(z, pos.z)

			plr:set_pos(vector.new(nx, ny, nz))
		end
	end
})

core.register_chatcommand("repeat", {
	params = "<times> <delay> <command>",
	description = "Execute <command> <times> times waiting <delay> seconds per iteration",
	func = function(name, param)
		local found, _, times, delay, command = param:find("^([^%s]+)%s+([^%s]+)%s+(.*)$")

		if found == nil then
			core.chat_send_player(name, "Invalid usage: " .. param)
			return
		end

		local c = 1
		local t = tonumber(times)
		local d = tonumber(delay)

		local function action()
			PyuTest.execute_as(name, command)

			if c == t then return end
			c = c + 1

			core.after(d, action)
		end

		action()
	end
})

core.register_chatcommand("execute", {
	params = "at|as <player> <command>",
	description = "Execute <command> as or at <player>",
	func = function (name, param)
		local found, _, method, player, command = param:find("^([^%s]+)%s+([^%s]+)%s+(.*)$")

		if found == nil then
			core.chat_send_player(name, "Invalid usage: " .. param)
			return
		end
		local targets = PyuTest.chatcommand_entity_selector(name, player)

		for _, v in pairs(targets) do
			if not core.get_player_by_name(v) then
				core.chat_send_player(name, "Invalid player: " .. v)
				return
			end
		end

		for _, v in pairs(targets) do
			if method == "as" then
				return PyuTest.execute_as(v, command)
			elseif method == "at" then
				-- TODO
			end
		end

	end
})

dofile(modpath .. "/worldedit.lua")
dofile(modpath .. "/gameplay.lua")
dofile(modpath .. "/fun.lua")
