local DELAYS = {
	0.2,
	0.4,
	0.6,
	0.8,
	1.0
}

local DELAY_POSITION_KEY = "delay"

local function after_place_node(pos)
	local meta = core.get_meta(pos)
	meta:set_int(DELAY_POSITION_KEY, 1)

	PyuTest.component_after_place_node(pos)
end

local function on_rightclick(pos, node, clicker)
	local meta = core.get_meta(pos)
	local dpos = meta:get_int(DELAY_POSITION_KEY)

	if dpos == #DELAYS then
		meta:set_int(DELAY_POSITION_KEY, 1)
	else
		meta:set_int(DELAY_POSITION_KEY, dpos + 1)
	end

	local seconds = DELAYS[meta:get_int(DELAY_POSITION_KEY)]
	core.chat_send_player(clicker:get_player_name(), string.format("Delay set to %f seconds", seconds))
end

PyuTest.make_electricity_device("pyutest_electricity:delayer", "Delayer", {
	cracky = PyuTest.BLOCK_NORMAL
}, {"pyutest-delayer.png"}, nil, {
	after_place_node = after_place_node,
	on_rightclick = on_rightclick
}, function (pos, node, sender_pos, sender)
	local meta = core.get_meta(pos)
	local seconds = DELAYS[meta:get_int(DELAY_POSITION_KEY)]

	core.after(seconds, function ()
		PyuTest.component_action(pos, sender)
	end)
end)

core.register_craft({
	output = "pyutest_electricity:delayer",
	recipe = {
		{ "group:cobble", "group:cobble", "group:cobble" },
		{ "group:cobble", "pyutest_ores:zinc_ingot",  "group:cobble" },
		{ "group:cobble", "group:cobble", "group:cobble" }
	},
})
