local modpath = core.get_modpath(core.get_current_modname())

dofile(modpath .. "/api.lua")

local function to_minutes(x)
	return x * 60
end

PyuTest.make_crop("pyutest_farming:wheat", "Wheat", "pyutest_tools:wheat 2", to_minutes(4), 0.5, {
	crop_color = "#eed89a",
	grown_color = "#eed89a",
	seed_color = "#eed89a"
})

PyuTest.make_crop("pyutest_farming:carrot", "Carrot", "pyutest_tools:carrot 3", to_minutes(6), 0.33, {
	crop_color = "#d19d79",
	grown_color = "#d19d79",
	seed_color = "#d19d79"
})

PyuTest.make_crop("pyutest_farming:potato", "Potato", "pyutest_tools:potato 5", to_minutes(5), 0.33, {
	crop_color = "#9e7b58",
	grown_color = "#9e7b58",
	seed_color = "#9e7b58"
})

PyuTest.make_node("pyutest_farming:pumpkin", "Pumpkin", {
	oddly_breakable_by_hand = PyuTest.BLOCK_SLOW,
	choppy = PyuTest.BLOCK_FAST,
	block = 1
}, {
	"pyutest-pumpkin-top.png",
	"pyutest-pumpkin-bottom.png",
	"pyutest-pumpkin-sides.png"
}, {})

PyuTest.make_crop("pyutest_farming:pumpkin", "Pumpkin", "", to_minutes(8), 0.33, {
	crop_color = "#ce6b28",
	seed_color = "#ce6b28"
}, "pyutest_farming:pumpkin")

core.register_craft({
	output = "pyutest_farming:pumpkin_seeds 4",
	recipe = {
		"pyutest_farming:pumpkin"
	},
	type = "shapeless"
})
