PyuTest.registered_colored_blocks = {}
PyuTest.make_colored_blocks = function(name, desc, color)
	PyuTest.make_building_blocks(name .. "_wool", desc .. " Wool", {
		"pyutest-wool.png"
	}, color, {
		wooly = PyuTest.BLOCK_NORMAL,
		colored = 1,
	})

	PyuTest.make_building_blocks(name .. "_terracotta", desc .. " Terracotta", {
		"pyutest-terracotta.png"
	}, color, {
		cracky = PyuTest.BLOCK_NORMAL,
		colored = 1,
	}, {
		_pyutest_blast_resistance = 3
	})

	PyuTest.make_building_blocks(name .. "_concrete", desc .. " Concrete", {
		"pyutest-concrete.png"
	}, color, {
		cracky = PyuTest.BLOCK_NORMAL,
		colored = 1,
	}, {
		_pyutest_blast_resistance = 2
	})

	PyuTest.make_item(name .. "_dye", desc .. " Dye", {
		colored = 1,
		dye = 1
	}, "pyutest-dye.png", {
		color = color or "white"
	})

	core.register_craft({
		output = name .. "_wool_block",
		type = "shapeless",
		recipe = {
			"pyutest_wool:white_wool_block",
			name .. "_dye"
		}
	})

	core.register_craft({
		output = name .. "_terracotta_block",
		type = "shapeless",
		recipe = {
			"pyutest_wool:white_terracotta_block",
			name .. "_dye"
		}
	})

	core.register_craft({
		output = name .. "_concrete_block",
		type = "shapeless",
		recipe = {
			"pyutest_wool:white_concrete_block",
			name .. "_dye"
		}
	})

	PyuTest.registered_colored_blocks[name] = {
		wool = name .. "_wool",
		terracotta = name .. "_terracotta",
		dye = name .. "_dye"
	}
end

PyuTest.make_colored_blocks("pyutest_wool:white", "White", "white")
core.register_craft({
	output = "pyutest_wool:white_wool_block 4",
	recipe = {
		{ "pyutest_tools:string", "pyutest_tools:string" },
		{ "pyutest_tools:string", "pyutest_tools:string" }
	}
})

core.register_craft({
	type = "cooking",
	output = "pyutest_wool:white_terracotta_block",
	recipe = "pyutest_blocks:clay_block"
})

core.register_craft({
	output = "pyutest_wool:white_concrete_block 4",
	recipe = {
		"pyutest_blocks:clay_block"
	},
	type = "shapeless"
})

for k, v in pairs(PyuTest.COLORS) do
	PyuTest.make_colored_blocks("pyutest_wool:" .. k, v[1], v[2])
end

for k, v in pairs(PyuTest.COLORS) do
	if v[2] ~= nil then
		local id = "pyutest_wool:" .. k .. "_stained_glass"
		local id2 = "pyutest_wool:" .. k .. "_stained_reinforced_glass"

		PyuTest.make_node(id, v[1] .. " Stained Glass", {
			oddly_breakable_by_hand = PyuTest.BLOCK_FAST,
			glass = 1,
			colored = 1
		}, { "pyutest-glass.png", "pyutest-glass-overlay.png" }, {
			drawtype = "glasslike_framed",
			color = v[2],
			paramtype = "light",
			sunlight_propagates = true
		})

		PyuTest.make_node(id2, v[1] .. " Stained Reinforced Glass", {
			cracky = PyuTest.BLOCK_NORMAL,
			glass = 1,
			colored = 1
		}, { "pyutest-glass.png", "pyutest-glass-overlay-reinforced.png" }, {
			drawtype = "glasslike_framed",
			color = v[2],
			paramtype = "light",
			sunlight_propagates = true
		})

		core.register_craft({
			output = id,
			recipe = {
				"pyutest_blocks:glass",
				"pyutest_wool:" .. k .. "_dye"
			},
			type = "shapeless"
		})

		core.register_craft({
			output = id2,
			recipe = {
				"pyutest_blocks:reinforced_glass",
				"pyutest_wool:" .. k .. "_dye"
			},
			type = "shapeless"
		})
	end
end

PyuTest.make_dye_mixing_recipe = function(c1, c2, out)
	core.register_craft({
		type = "shapeless",
		output = out .. " 2",
		recipe = {
			c1, c2
		}
	})
end

PyuTest.make_dye_mixing_recipe("pyutest_wool:red_dye", "pyutest_wool:blue_dye", "pyutest_wool:purple_dye")
PyuTest.make_dye_mixing_recipe("pyutest_wool:red_dye", "pyutest_wool:yellow_dye", "pyutest_wool:orange_dye")
PyuTest.make_dye_mixing_recipe("pyutest_wool:yellow_dye", "pyutest_wool:blue_dye", "pyutest_wool:green_dye")
PyuTest.make_dye_mixing_recipe("pyutest_wool:red_dye", "pyutest_wool:white_dye", "pyutest_wool:pink_dye")
PyuTest.make_dye_mixing_recipe("pyutest_wool:red_dye", "pyutest_wool:green_dye", "pyutest_wool:brown_dye")
