local pl = {}

local function fill_for(player)
	local name = player:get_player_name()

	local pos = player:get_pos()
	local def = PyuTest.get_biome_def(pos)

	if def == nil then
		if pl[name] ~= nil then
			core.sound_stop(pl[name])
			pl[name] = nil
		end

		return
	end

	local ambient = def._pyutest_ambient

	if ambient == nil then
		return
	end

	if pl[name] == nil then
		pl[name] = core.sound_play(ambient, {
			player = name,
			loop = true
		})
	end
end

core.register_globalstep(function ()
	for _, player in ipairs(core.get_connected_players()) do
		fill_for(player)
	end
end)
