core.register_decoration({
	deco_type = "simple",
	sidelen = 16,
	fill_ratio = 0.0003,
	place_on = { "group:ground" },
	decoration = PyuTest.spawning_lootboxes
})

PyuTest.register_structure("igloo", "Igloo", {
	place_on = { "pyutest_blocks:snow_block" },
	fill_ratio = 0.00004,
	biomes = { "FrozenPlains" },
	rotation = "random",
	flags = "place_center_x, place_center_z",
	place_offset_y = 1
})

PyuTest.register_structure("desert_well", "DesertWell", {
	place_on = { "pyutest_blocks:sand_block" },
	fill_ratio = 0.00006,
	biomes = { "Desert" },
	rotation = "random"
})

PyuTest.register_structure("ice_spike", "IceSpike", {
	fill_ratio = 0.0008,
	place_on = {
		"pyutest_blocks:ice_block",
	},
	biomes = {
		"IceSpikes",
	},
})

PyuTest.register_structure("ocean_ruins", "OceanRuins", {
	fill_ratio = 0.0002,
	place_on = { "pyutest_blocks:gravel_block" },
	biomes = PyuTest.get_biomes_from_type(PyuTest.BIOME_TYPES.OCEAN),
	y_max = PyuTest.OVERWORLD_DEEP_OCEAN_MAX + 4,
	y_min = PyuTest.OVERWORLD_DEEP_OCEAN_MIN,
	spawn_by = { "pyutest_blocks:water_source" },
	num_spawn_by = 2
})

PyuTest.register_structure("fossil", "Fossil", {
	fill_ratio = 9 / 10000, -- 9 out of every 10000 blocks should spawn fossils
	place_on = {
		"pyutest_blocks:molten_rock_block",
		"pyutest_blocks:magma"
	},
	biomes = PyuTest.LavaWorld.biome_names
})
