local function formspec()
	return table.concat({
		"field[setcmd;Set Command;${command}]"
	})
end

PyuTest.make_electricity_device("pyutest_electricity:command_block", "Command Block", {
	cracky = PyuTest.BLOCK_FAST,
}, {"pyutest-device.png"}, nil, {
	after_place_node = function(pos, placer)
		local meta = core.get_meta(pos)
		meta:set_string("owner", placer:get_player_name())
		meta:set_string("command", "say Hello World!")
		meta:set_string("formspec", formspec())
	end,
	on_receive_fields = function(pos, formname, fields, player)
		if fields.setcmd then
			local cmd = fields.setcmd
			local meta = core.get_meta(pos)
			meta:set_string("command", cmd)
		end
	end
}, function (pos, node, sender_pos)
	local meta = core.get_meta(pos)
	local owner = meta:get_string("owner")
	local command = meta:get_string("command")

	PyuTest.execute_as(owner, command)
end)
