PyuTest.FURNITURE_NODEBOXES = {
	TABLE = {
		type = "connected",
		fixed = {
			{ -0.5,  0.5,  -0.5,  0.5,  0.45, 0.5 },
			{ -0.15, -0.5, -0.15, 0.15, 0.45, 0.15 },
		},
	}
}

PyuTest.registered_furniture = {}
PyuTest.make_furniture = function(name, desc, craft, tiles, cgroups, extra_conf)
	local econf = extra_conf or {}
	local groups = PyuTest.util.tablecopy(cgroups) or {}
	groups["block"] = 0
	groups["furniture"] = 1

	local id_table = name .. "_table"
	local id_chair = name .. "_chair"
	local id_sofa = name .. "_sofa"
	local id_mtable = name .. "_mtable"

	core.register_node(id_table, PyuTest.util.tableconcat({
		description = Translate(desc .. " Table"),
		tiles = tiles,
		groups = PyuTest.util.tableconcat(groups, {
			table = 1
		}),
		sounds = PyuTest.make_node_sounds(),
		drawtype = "nodebox",
		paramtype = "light",
		node_box = PyuTest.FURNITURE_NODEBOXES.TABLE,
		connects_to = { "group:table" }
	}, econf))

	core.register_node(id_chair, PyuTest.util.tableconcat({
		description = Translate(desc .. " Chair"),
		tiles = tiles,
		groups = PyuTest.util.tableconcat(groups, {
			chair = 1,
			attached_node = 3,
		}),
		sounds = PyuTest.make_node_sounds(),
		paramtype = "light",
		paramtype2 = "color4dir",
		drawtype = "mesh",
		mesh = "pyutest-chair.obj",
		selection_box = {
			type = "fixed",
			fixed = { -0.5, -0.5, -0.5, 0.5, 1.1, 0.5 }
		},
		collision_box = {
			type = "fixed",
			fixed = {
				{ -0.5, -0.5, -0.5, 0.5, 0.10, 0.5 }
			}
		}
	}, econf))

	core.register_node(id_sofa, PyuTest.util.tableconcat({
		description = Translate(desc .. " Sofa"),
		tiles = tiles,
		groups = PyuTest.util.tableconcat(groups, {
			sofa = 1,
			attached_node = 3,
		}),
		sounds = PyuTest.make_node_sounds(),
		paramtype = "light",
		paramtype2 = "color4dir",
		drawtype = "mesh",
		mesh = "pyutest-sofa.obj",
		selection_box = PyuTest.NODEBOX_DEFAULT,
		collision_box = {
			type = "fixed",
			fixed = {
				{ -0.5, -0.65, -0.5, 0.5, 0, 0.5 }
			}
		}
	}, econf))

	core.register_node(id_mtable, PyuTest.util.tableconcat({
		description = Translate(desc .. " Mini Table"),
		tiles = tiles,
		groups = PyuTest.util.tableconcat(groups, {
			mtable = 1,
			attached_node = 3,
		}),
		sounds = PyuTest.make_node_sounds(),
		paramtype = "light",
		paramtype2 = "color4dir",
		drawtype = "mesh",
		mesh = "pyutest-mtable.obj",
		selection_box = {
			type = "fixed",
			fixed = { -0.5, -0.5, -0.5, 0.5, 0.25, 0.5 }
		},
		collision_box = {
			type = "fixed",
			fixed = {
				{ -0.5, -0.5, -0.5, 0.5, 0.25, 0.5 }
			}
		}
	}, econf))

	core.register_craft({
		output = id_table .. " 4",
		recipe = {
			{ craft, craft, craft },
			{ "",    craft, "" },
			{ "",    craft, "" }
		}
	})

	core.register_craft({
		output = id_chair .. " 4",
		recipe = {
			{ craft, "",    "" },
			{ craft, craft, craft },
			{ craft, "",    craft }
		}
	})

	core.register_craft({
		output = id_sofa .. " 4",
		recipe = {
			{ craft, "",    craft },
			{ craft, craft, craft },
			{ craft, "",    craft }
		}
	})

	core.register_craft({
		output = id_mtable .. " 4",
		recipe = {
			{ craft, craft, craft },
			{ craft, craft, craft },
			{ craft, "", craft}
		}
	})

	PyuTest.registered_furniture[name] = {
		craft = craft,
		groups = groups,
		tiles = tiles,
		econf = econf
	}
end

for _, v in pairs(PyuTest.building_blocks) do
	local c = v.ns .. ":" .. v.name-- .. "_block"
	PyuTest.make_furniture("pyutest_furniture:" .. v.name, v.desc, c, v.tiles, v.groups, v.econf)
end
