core.register_alias("mapgen_stone", "pyutest_blocks:stone")
core.register_alias("mapgen_water_source", "pyutest_blocks:water_source")
core.register_alias("mapgen_river_water_source", "pyutest_blocks:water_source")
core.register_alias("mapgen_lava_source", "pyutest_blocks:lava_source")
core.register_alias("mapgen_singlenode", "air")

local settings = core.settings
local mg_flags = settings:get_flags("mg_flags")
local mg_name = core.get_mapgen_setting("mg_name")
core.set_mapgen_setting("water_level", tostring(PyuTest.OVERWORLD_SURFACE_BOTTOM), true)

core.set_mapgen_setting(string.format("mg%s_cavern_threshold", mg_name), "0.20", true)
core.set_mapgen_setting(string.format("mg%s_mount_zero_level", mg_name), "0.42", true)
core.set_mapgen_setting(string.format("mg%s_cave_width", mg_name), "0.003", true)
core.set_mapgen_setting(string.format("mg%s_large_cave_num_min", mg_name), "1", true)
core.set_mapgen_setting(string.format("mg%s_large_cave_num_max", mg_name), "4", true)

mg_flags.caverns = true
mg_flags.dungeons = false

-- https://git.minetest.land/VoxeLibre/VoxeLibre/src/branch/master/mods/MAPGEN/mcl_mapgen_core/init.lua#L127
local mg_flags_str = ""
for k, v in pairs(mg_flags) do
	if v == false then
		k = "no" .. k
	end
	mg_flags_str = mg_flags_str .. k .. ","
end
if string.len(mg_flags_str) > 0 then
	mg_flags_str = string.sub(mg_flags_str, 1, string.len(mg_flags_str) - 1)
end
core.set_mapgen_setting("mg_flags", mg_flags_str, true)

local function change_np_group(key, fn)
	local np = core.get_mapgen_setting_noiseparams(key)

	if np then
		np = PyuTest.util.tableconcat(fn(np), np)

		core.set_mapgen_setting_noiseparams(key, np, true)
	end
end

change_np_group(string.format("mg%s_np_cave1", mg_name), function ()
	return {
		spread = {
			x = 447,
			y = 447,
			z = 247
		}
	}
end)

change_np_group(string.format("mg%s_np_cave2", mg_name), function ()
	return {
		spread = {
			x = 235,
			y = 235,
			z = 235
		}
	}
end)

change_np_group(string.format("mg%s_np_mountain", mg_name), function ()
	return {
		spread = {
			x = 400,
			y = 520,
			z = 400,
		}
	}
end)

change_np_group(string.format("mg%s_np_mount_height", mg_name), function ()
	return {
		spread = {
			x = 1350,
			z = 1350,
		}
	}
end)

change_np_group(string.format("mg%s_np_terrain_base", mg_name), function ()
	return {
		scale = 160,
		spread = {
			x = 925,
			z = 925,
		}
	}
end)


change_np_group(string.format("mg%s_np_terrain_alt", mg_name), function ()
	return {
		spread = {
			x = 725,
			z = 725,
		}
	}
end)
