PyuTest.make_node("pyutest_blocks:fire", "Fire", {
	dig_immediate = 3,
	oddly_breakable_by_hand = PyuTest.BLOCK_FAST,
	emits_heat = 1,
	not_in_creative_inventory = 1,
	fire_spreading = 1
}, {
	{
		name = "pyutest-fire-animated.png",
		animation = {
			type = "vertical_frames",
			aspect_w = 16,
			aspect_h = 16,
			length = 1.2
		}
	}
}, {
	drawtype = "firelike",
	walkable = false,
	floodable = true,
	buildable_to = true,
	paramtype = "light",
	sunlight_propagates = true,
	damage_per_second = 2,
	light_source = 8,
	drop = "pyutest_tools:ash 2",
	_pyutest_blast_resistance = 0,
})

core.register_abm({
	label = "Fire Spread",
	nodenames = { "group:flammable" },
	neighbors = { "group:fire_spreading" },
	interval = 1,
	chance = 4,
	action = function(pos)
		if not core.settings:get_bool("fire_spreads", true) then
			return
		end

		core.set_node(pos, {
			name = "pyutest_blocks:fire"
		})
	end
})

core.register_abm({
	label = "Fire Extinguish",
	nodenames = { "pyutest_blocks:fire" },
	interval = 1,
	chance = 16,
	action = function(pos)
		local name = core.get_node(pos - vector.new(0, 1, 0)).name
		if core.get_item_group(name, "fire_persist") ~= 0 then
			return
		end

		core.remove_node(pos)
	end
})

core.register_abm({
	label = "Fire Extinguish",
	nodenames = {"pyutest_blocks:fire"},
	neighbors = {"group:destroys_fire"},
	interval = 1,
	chance = 1,
	action = function (pos)
		core.remove_node(pos)
	end
})
