PyuTest.FOLIAGE_TYPES = {
	NORMAL = 0,
	DARK = 1,
	SWAMP = 2,
	DRY = 3,
	ASPEN = 4,
	JUNGLE = 5,
	SNOW = 6,
	MAGIC = 7,
	LIGHT = 8,
	DEAD = 9,
	OCEANIC = 10,
	LUSH = 11,
}

local function on_construct(n)
	return function (pos)
		local node = core.get_node(pos)
		if node.param2 == 0 then
			local new_node = PyuTest.get_foliage_type(pos, n)
			if new_node.param2 ~= 0 or new_node.name ~= n then
				core.set_node(pos, new_node)
			end
		end
	end
end

PyuTest.make_node("pyutest_blocks:grass", "Grass", {
	grass = 1,
	dirt = 1,
	crumbly = PyuTest.BLOCK_FAST,
	acid_vulnerable = 1,
	foliage = 1,
	grass_spawn = 1,
	block = 1,
	ground = 1,
}, nil, {
	paramtype2 = "color",
	palette = "pyutest-foliage-palette.png",
	palette_index = 0,
	color = "#6baf4a",
	tiles = {"pyutest-grass-top.png", {name = "pyutest-dirt.png", color = "white"}},
	overlay_tiles = {"pyutest-grass-top.png", "blank.png", "pyutest-grass-side.png"},
	is_ground_content = true,
	on_construct = on_construct("pyutest_blocks:grass")
})

local function make_plant_drops(name)
	return {
		max_items = 1,
		items = {
			{
				tool_groups = {
					"shears"
				},
				items = { name }
			}
		}
	}
end

PyuTest.make_node("pyutest_blocks:grass_plant", "Grass Plant", {
	flammable = 1,
	flower = 1,
	attached_node = 3,
	dig_immediate = 1,
	foliage = 1,
	oddly_breakable_by_hand = PyuTest.BLOCK_FAST,
	snappy = PyuTest.BLOCK_FAST,
}, {"pyutest-grass-plant.png"}, {
	drawtype = "plantlike",
	waving = 1,
	buildable_to = true,
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	selection_box = PyuTest.NODE_BOXES.SMALL,
	paramtype2 = "color",
	palette = "pyutest-foliage-palette.png",
	palette_index = 0,
	color = "#6baf4a",
	drop = make_plant_drops("pyutest_blocks:grass_plant"),
	on_construct = on_construct("pyutest_blocks:grass_plant"),
	_pyutest_blast_resistance = 0,
})

PyuTest.make_node("pyutest_blocks:fern", "Fern", {
	flammable = 1,
	flower = 1,
	attached_node = 3,
	dig_immediate = 1,
	foliage = 1,
	oddly_breakable_by_hand = PyuTest.BLOCK_FAST,
	snappy = PyuTest.BLOCK_FAST,
}, {"pyutest-fern.png"}, {
	drawtype = "plantlike",
	waving = 1,
	buildable_to = true,
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	selection_box = PyuTest.NODE_BOXES.SMALL,
	paramtype2 = "color",
	palette = "pyutest-foliage-palette.png",
	palette_index = 0,
	color = "#6baf4a",
	drop = make_plant_drops("pyutest_blocks:fern"),
	on_construct = on_construct("pyutest_blocks:fern"),
	_pyutest_blast_resistance = 0,
})

-- foliage won't be coloured if not for this.
core.register_lbm({
	name = "pyutest_blocks:foliage_conversion",
	nodenames = {"group:foliage"},
	run_at_every_load = true,
	action = function (pos, node)
		core.set_node(pos, {name = node.name})
	end
})

core.register_abm({
	nodenames = {"group:foliage"},
	interval = 0,
	chance = 1,
	action = function (pos)
		local n = core.get_node(pos)
		local n2 = PyuTest.get_foliage_type(pos, n.name)

		if n.param2 ~= n2.param2 then
			core.set_node(pos, n2)
		end
	end
})

core.register_decoration({
	deco_type = "simple",
	place_on = { "group:grass_spawn" },
	sidelen = 16,
	fill_ratio = 0.048,
	decoration = "pyutest_blocks:grass_plant"
})

core.register_decoration({
	deco_type = "simple",
	place_on = { "group:grass_spawn" },
	sidelen = 16,
	fill_ratio = 0.024,
	decoration = "pyutest_blocks:fern"
})
