PyuTest.make_fence = function(name, desc, craftitem, texture, groups, extra)
	core.register_node(name, PyuTest.util.tableconcat({
		description = Translate(desc),
		groups = PyuTest.util.tableconcat(groups, {
			block = 1,
			fence = 1,
		}),
		connects_to = {"group:block", "group:fence"},
		tiles = texture,
		is_ground_content = false,
		sunlight_propagates = true,
		sounds = PyuTest.make_node_sounds(),
		paramtype = "light",
		drawtype = "nodebox",

		-- Node boxes from Minetest Game
		node_box = {
			type = "connected",
			fixed = {-1/8, -1/2, -1/8, 1/8, 1/2, 1/8},
			connect_front = {{-1/16,  3/16, -1/2,   1/16,  5/16, -1/8 },
			{-1/16, -5/16, -1/2,   1/16, -3/16, -1/8 }},
			connect_left =  {{-1/2,   3/16, -1/16, -1/8,   5/16,  1/16},
			{-1/2,  -5/16, -1/16, -1/8,  -3/16,  1/16}},
			connect_back =  {{-1/16,  3/16,  1/8,   1/16,  5/16,  1/2 },
			{-1/16, -5/16,  1/8,   1/16, -3/16,  1/2 }},
			connect_right = {{ 1/8,   3/16, -1/16,  1/2,   5/16,  1/16},
			{ 1/8,  -5/16, -1/16,  1/2,  -3/16,  1/16}}
		},
		collision_box = {
			type = "connected",
			fixed = {-1/8, -1/2, -1/8, 1/8, 1/2 + 3/8, 1/8},
			connect_front = {-1/8, -1/2, -1/2,  1/8, 1/2 + 3/8, -1/8},
			connect_left =  {-1/2, -1/2, -1/8, -1/8, 1/2 + 3/8,  1/8},
			connect_back =  {-1/8, -1/2,  1/8,  1/8, 1/2 + 3/8,  1/2},
			connect_right = { 1/8, -1/2, -1/8,  1/2, 1/2 + 3/8,  1/8}
		},
	}, extra or {}))

	core.register_craft({
		output = name .. " 4",
		recipe = {
			{ craftitem, "group:stick", craftitem },
			{ craftitem, "group:stick", craftitem }
		}
	})
end
