PyuTest.registered_spellbooks = {}
PyuTest.make_spellbook = function(nsname, desc, color, mana, craftitem, action)
	if action == nil then
		action = function(_, _, _) end
	end

	PyuTest.make_item(nsname, desc, {}, "pyutest-spellbook.png", {
		stack_max = 1,
		color = color,
		on_use = function(itemstack, user, pointed_thing)
			if not PyuTest.use_mana(user:get_player_name(), mana) then
				return
			end
			local pos = user:get_pos()
			core.sound_play({ name = "pyutest_magic_action", gain = 0.75 }, { pos = pos })
			action(itemstack, user, pointed_thing)
		end
	})

	core.register_craft({
		output = nsname,
		recipe = {
			{ "",                           "pyutest_magic:magic_shards", "" },
			{ "pyutest_magic:magic_shards", craftitem,                    "pyutest_magic:magic_shards" },
			{ "",                           "pyutest_magic:magic_shards", "" }
		}
	})

	PyuTest.registered_spellbooks[nsname] = {
		color = color,
		craftitem = craftitem,
		action = action
	}
end

PyuTest.make_spellbook("pyutest_magic:explosions_spellbook", "Spellbook of Explosions", "gray", 10, "pyutest_tools:bomb",
function(itemstack, user)
	PyuTest.create_explosion(user:get_pos(), 2, false, 7, { user })
end)

PyuTest.make_spellbook("pyutest_magic:healing_spellbok", "Spellbook of Healing", "gold",
30, "pyutest_tools:golden_apple", function (itemstack, user)
	for e in core.objects_inside_radius(user:get_pos(), 2) do
		PyuTest.deal_damage(e, -10, PyuTest.DAMAGE_TYPES.magic())
	end
end)
