PyuTest.create_boss_egg = function(mob_id, desc, texture, addegg, no_creative, craft)
	mobs:register_egg(mob_id, desc, texture, addegg, no_creative)

	core.register_craft({
		output = mob_id,
		recipe = {
			{ "",    craft,                        "" },
			{ craft, "pyutest_ores:emerald_shard", craft },
			{ "",    craft,                        "" }
		}
	})

	local t = mob_id:split(":")
	local mob_name = t[#t]

	local cage_id = "pyutest_mobs:" .. mob_name .. "_spawn_cage"
	PyuTest.make_node(cage_id, desc:gsub("Spawn Egg", "") .. "Boss Spawner Cage", {
		cracky = PyuTest.BLOCK_SLOW
	}, { "pyutest-cage.png" }, {
		drawtype = "glasslike",
		on_rightclick = function(pos)
			mobs:add_mob(vector.add(pos, vector.new(0, 1, 0)), {
				name = mob_id,
				child = false,
				ignore_count = true
			})
			core.remove_node(pos)
		end
	})
end
