PyuTest.chatcommand_entity_selector = function(caller, param)
	local p_caller = core.get_player_by_name(caller)

	-- if param == nil then
	--   return {param}
	-- end

	if param == "@self" or param == "@s" then
		return {caller}
	elseif param == "@random" or param == "@r" then
		local players = core.get_connected_players()
		return {players[math.random(#players)]:get_player_name()}
	elseif param == "@nearest" or param == "@n" then
		local players = core.get_connected_players()
		local pos = p_caller:get_pos()
		local cd = math.huge
		local nearest

		for _, v in pairs(players) do
			local dist = vector.distance(pos, v:get_pos())

			if dist < cd and v ~= p_caller then
				cd = dist
				nearest = v
			end
		end

		if nearest then
			return {nearest:get_player_name()}
		end
	elseif param == "@all" or param == "@a" then
		local list = {}

		for _, v in pairs(core.get_connected_players()) do
			list[#list+1] = v:get_player_name()
		end

		return list
	end

	return {caller}
end

PyuTest.execute_as = function(runner, command)
	local pos = command:find(" ")
	local cmd, param = command, ""
	if pos then
		cmd = command:sub(1, pos - 1)
		param = command:sub(pos + 1)
	end
	local cmddef = core.chatcommands[cmd]
	if not cmddef then
		core.chat_send_player(runner, "The command "..cmd.." does not exist")
		return
	end
	local has_privs, missing_privs = core.check_player_privs(runner, cmddef.privs)
	if not has_privs then
		core.chat_send_player(runner, "You don't have permission "
		.."to run "..cmd
		.." (missing privileges: "
		..table.concat(missing_privs, ", ")..")")
		return
	end

	return cmddef.func(runner, param)
end

PyuTest.parse_command_functions = function(runner, param)
	local str = param

	-- embed the output of command
	str = str:gsub(".embed<([^%s]+)>", function(input)
		return PyuTest.execute_as(runner, input) or ""
	end)

	return str
end
