
local function has_cloud_control(player)
	return player:get_meta():contains("clouds_enabled")
end

local function get_clouds_enabled(player)
	return player:get_meta():get_int("clouds_enabled") == 1
end

local function set_clouds_enabled(player, enabled)
	return player:get_meta():set_int("clouds_enabled", enabled and 1 or 0)
end

core.register_chatcommand("toggle_clouds", {
	params = "",
	description = "Toggle clouds on or off for yourself",
	func = function(name)
		local player = core.get_player_by_name(name)

		local clouds_enabled = get_clouds_enabled(player)

		local new_state = not clouds_enabled

		set_clouds_enabled(player, new_state)
		player:set_sky{clouds = new_state}

		return true,
			"Clouds have been " .. (new_state and "enabled" or "disabled") .. "."
	end,
})

core.register_on_joinplayer(function(player)
	if has_cloud_control(player) then
		player:set_sky{ clouds = get_clouds_enabled(player) }
	end
end)
