-- Register the /destroy command
minetest.register_chatcommand("destroy", {
    description = "Mangles a 32x32 area around the player",
    func = function(name, param)
        local player = minetest.get_player_by_name(name)
        if not player then
            return false, "Player not found!"
        end

        local pos = player:get_pos()
        local radius = 16  -- Half of 32x32 area

        for x = -radius, radius do
            for y = -radius, radius do
                for z = -radius, radius do
                    if math.random() > 0.4 then  -- 40% chance to delete the block
                        local current_pos = {x = pos.x + x, y = pos.y + y, z = pos.z + z}
                        local node = minetest.get_node(current_pos)
                        if node.name ~= "air" then  -- Don't delete air
                            minetest.remove_node(current_pos)
                        end
                    end
                end
            end
        end

        minetest.chat_send_player(name, "The destruction has begun!")
        return true
    end,
})

