minetest.register_node("regenerative_ores:regen_stone_with_coal", {
    description = "Regenerative Coal",
    tiles = { "default_stone.png^default_mineral_coal.png" },
    is_ground_content = true,
    groups = { cracky = 3, stone = 1 },
    drop = "",
    sounds = default.node_sound_stone_defaults(),
    after_dig_node = function(pos, oldnode, oldmeta, digger)
        minetest.set_node(pos, { name = "regenerative_ores:regen_node_coal" })

        give_or_drop_item(pos, digger:get_player_name(), "default:coal_lump")
    end
})

minetest.register_node("regenerative_ores:regen_node_coal", {
    description = "Regenerating Coal",
    tiles = { "default_stone.png" },
    groups = { cracky = 3, not_in_creative_inventory = 1 },
    drop = "",
    sounds = default.node_sound_stone_defaults(),
    on_construct = function(pos)
        minetest.get_node_timer(pos):start(10)
    end,
    on_timer = function(pos)
        minetest.set_node(pos, { name = "regenerative_ores:regen_stone_with_coal" })
    end
})
