local old_is_protected = minetest.is_protected

local function is_regen_ore(name)
    if name == "regenerative_ores:regen_stone_with_coal" or
        name == "regenerative_ores:regen_stone_with_iron" or
        name == "regenerative_ores:regen_stone_with_gold" or
        name == "regenerative_ores:regen_stone_with_diamond" or
        name == "regenerative_ores:regen_stone_with_mese" then
        return true
    end
end

function minetest.is_protected(pos, name)
    if is_regen_ore(minetest.get_node(pos).name) then
        return false
    end

    return old_is_protected(pos, name)
end

function give_or_drop_item(pos, player_name, item_name)
    local player = minetest.get_player_by_name(player_name)
    if not player then
        return false
    end

    local itemstack = ItemStack(item_name)

    
    local leftover = player:get_inventory():add_item("main", itemstack)

    
    if not leftover:is_empty() then
        local drop_pos = vector.add(pos, { x = 0, y = 1, z = 0 })
        minetest.add_item(drop_pos, leftover)
    end

    return true
end

dofile(minetest.get_modpath("regenerative_ores") .. "/coal.lua")
dofile(minetest.get_modpath("regenerative_ores") .. "/iron.lua")
dofile(minetest.get_modpath("regenerative_ores") .. "/gold.lua")
dofile(minetest.get_modpath("regenerative_ores") .. "/diamond.lua")
dofile(minetest.get_modpath("regenerative_ores") .. "/mese.lua")