# Ruby Tools+

**Ruby Tools+** is a technology-style mod for Luanti / Minetest that adds ruby-based materials, tools, and machinery.  
The mod focuses on **machine-based processing** rather than crafting-table shortcuts.

---

## 🧱 Ores & Materials

### Ruby Ore
- **Node:** `ruby_tools_plus:ruby_ore`
- **Drops:** `ruby_tools_plus:ruby`
- **Where to find:**
  - Underground
  - Spawns between **Y = -256 to Y = -1024**
  - Common in deep stone layers

### Rubidium Ore
- **Node:** `ruby_tools_plus:rubidium_ore`
- **Drops:** `ruby_tools_plus:rubidium_lump`
- **Where to find:**
  - Very deep underground
  - Spawns between **Y = -496 to Y = -1056**
  - Much rarer than ruby ore

---

## 🔥 Alloy Fuser Machine

The **Alloy Fuser** is a machine used to combine multiple materials into advanced alloys.  
All alloying is **machine-only** and cannot be done in a crafting grid.

### How to use
1. Place the **Alloy Fuser**
2. Open its interface
3. Insert valid input items into the **input slots**
4. Insert a **lava bucket** as fuel
5. Wait for the alloying process to complete

---

## ⛽ Fuel

The Alloy Fuser currently accepts:
- `bucket:bucket_lava`

Each lava bucket powers **10 alloy operations**.

---

## ⚙ Alloy Recipes

### Rubidium Alloy
**Inputs (any order):**
- `ruby_tools_plus:refined_ruby`
- `ruby_tools_plus:rubidium_lump`

**Output:**
- `ruby_tools_plus:rubidium`

**Processing Time:**
- ⏱ **10 seconds per alloy**

---

## 📦 Output Behavior

- The output inventory supports **multiple different items**
- Outputs stack normally
- If output slots are full, processing will pause automatically

---

## 🔊 Effects & Feedback

- Uses the **vanilla furnace burning sound** while active
- Front texture changes when the machine is running
- Emits light while active
- Automatically shuts down when fuel runs out

---

## 📖 Crafting Philosophy

- Alloy recipes **cannot** be crafted in a crafting grid
- All alloy processing is done through machines
- Designed to be progression-friendly and tech-focused

---

## 📜 License

**Creative Commons Attribution-ShareAlike 3.0 (CC-BY-SA 3.0)**  

This mod uses and modifies Minetest textures.  
You are free to share and adapt this work as long as proper credit is given and derivative works are shared under the same license.

---

## 👤 Author

**Ruby Tools+**  
Developed by ReinPlayz