-- =========================
-- Ruby Recipes
-- Version: v0.1.5dev
-- =========================

-- Handle
minetest.register_craft({
    output = "ruby_tools_plus:handle",
    recipe = {
        {"", "", ""},
        {"", "default:stick", "default:cobble"},
        {"", "default:stick", "default:cobble"},
    }
})

-- Core
minetest.register_craft({
    output = "ruby_tools_plus:core",
    recipe = {
        {"default:cobble", "default:cobble", "default:cobble"},
        {"default:cobble", "default:torch", "default:cobble"},
        {"default:cobble", "default:cobble", "default:cobble"},
    }
})

-- Alloy
minetest.register_craft({
    output = "ruby_tools_plus:alloy",
    recipe = {
        {"default:cobble", "default:cobble", "default:cobble"},
        {"default:cobble", "ruby_tools_plus:heated_core", "default:cobble"},
        {"default:cobble", "default:cobble", "default:cobble"},
    }
})

-- Gear (Ruby Dust + Steel + Bronze)
minetest.register_craft({
    output = "ruby_tools_plus:gear",
    recipe = {
        {"default:bronze_ingot", "ruby_tools_plus:ruby_dust", "default:bronze_ingot"},
        {"ruby_tools_plus:ruby_dust", "default:steel_ingot", "ruby_tools_plus:ruby_dust"},
        {"default:bronze_ingot", "ruby_tools_plus:ruby_dust", "default:bronze_ingot"},
    }
})

-- Ruby Coil (Ruby Dust + Steel + Bronze)
minetest.register_craft({
    output = "ruby_tools_plus:ruby_coil",
    recipe = {
        {"default:steel_ingot", "default:steel_ingot", "default:steel_ingot"},
        {"ruby_tools_plus:ruby_dust", "default:bronze_ingot", "ruby_tools_plus:ruby_dust"},
        {"default:steel_ingot", "default:steel_ingot", "default:steel_ingot"},
    }
})

-- Ruby Block
minetest.register_craft({
    output = "ruby_tools_plus:ruby_block",
    recipe = {
        {"ruby_tools_plus:ruby","ruby_tools_plus:ruby","ruby_tools_plus:ruby"},
        {"ruby_tools_plus:ruby","ruby_tools_plus:ruby","ruby_tools_plus:ruby"},
        {"ruby_tools_plus:ruby","ruby_tools_plus:ruby","ruby_tools_plus:ruby"},
    }
})

-- Ruby Block reverse -> 9 Rubies
minetest.register_craft({
    output = "ruby_tools_plus:ruby 9",
    recipe = {{"ruby_tools_plus:ruby_block"}}
})

-- 9 Ruby Dust -> 1 Ruby
minetest.register_craft({
    output = "ruby_tools_plus:ruby",
    recipe = {
        {"ruby_tools_plus:ruby_dust","ruby_tools_plus:ruby_dust","ruby_tools_plus:ruby_dust"},
        {"ruby_tools_plus:ruby_dust","ruby_tools_plus:ruby_dust","ruby_tools_plus:ruby_dust"},
        {"ruby_tools_plus:ruby_dust","ruby_tools_plus:ruby_dust","ruby_tools_plus:ruby_dust"},
    }
})

-- Refined Ruby
minetest.register_craft({
	output = "ruby_tools_plus:refined_ruby",
	recipe = {
		{"", "default:steel_ingot", ""},
		{"ruby_tools_plus:ruby_dust", "ruby_tools_plus:ruby", "ruby_tools_plus:ruby_dust"},
		{"", "default:steel_ingot", ""},
	}
})

-- Alloy Fuser
minetest.register_craft({
	output = "ruby_tools_plus:alloy_fuser",
	recipe = {
		{"default:cobble", "default:cobble", "default:cobble"},
		{"ruby_tools_plus:alloy", "ruby_tools_plus:core", "ruby_tools_plus:alloy"},
		{"default:cobble", "default:cobble", "default:cobble"},
	}
})

-- Furnace recipes: smelting
minetest.register_craft({
    type = "cooking",
    output = "ruby_tools_plus:ruby",
    recipe = "ruby_tools_plus:ruby_ore",
    cooktime = 10,
})

minetest.register_craft({
    type = "cooking",
    output = "ruby_tools_plus:heated_core",
    recipe = "ruby_tools_plus:core",
    cooktime = 15,
})

-- Tool Recipes (replace sticks with handles)
-- Ruby Sword
minetest.register_craft({
    output = "ruby_tools_plus:ruby_sword",
    recipe = {
        {"", "ruby_tools_plus:ruby", ""},
        {"", "ruby_tools_plus:ruby", ""},
        {"", "ruby_tools_plus:handle", ""},
    }
})

-- Ruby Pickaxe
minetest.register_craft({
    output = "ruby_tools_plus:ruby_pickaxe",
    recipe = {
        {"ruby_tools_plus:ruby","ruby_tools_plus:ruby","ruby_tools_plus:ruby"},
        {"","ruby_tools_plus:handle",""},
        {"","ruby_tools_plus:handle",""},
    }
})

-- Ruby Shovel
minetest.register_craft({
    output = "ruby_tools_plus:ruby_shovel",
    recipe = {
        {"","ruby_tools_plus:ruby",""},
        {"","ruby_tools_plus:handle",""},
        {"","ruby_tools_plus:handle",""},
    }
})

-- Ruby Axe (both recipes)
minetest.register_craft({
    output = "ruby_tools_plus:ruby_axe",
    recipe = {
        {"ruby_tools_plus:ruby","ruby_tools_plus:ruby",""},
        {"ruby_tools_plus:ruby","ruby_tools_plus:handle",""},
        {"","ruby_tools_plus:handle",""},
    }
})

minetest.register_craft({
    output = "ruby_tools_plus:ruby_axe",
    recipe = {
        {"","ruby_tools_plus:ruby","ruby_tools_plus:ruby"},
        {"","ruby_tools_plus:handle","ruby_tools_plus:ruby"},
        {"","ruby_tools_plus:handle",""},
    }
})

-- Ruby Hoe (both recipes)
minetest.register_craft({
    output = "ruby_tools_plus:ruby_hoe",
    recipe = {
        {"ruby_tools_plus:ruby","ruby_tools_plus:ruby",""},
        {"","ruby_tools_plus:handle",""},
        {"","ruby_tools_plus:handle",""},
    }
})

minetest.register_craft({
    output = "ruby_tools_plus:ruby_hoe",
    recipe = {
        {"","ruby_tools_plus:ruby","ruby_tools_plus:ruby"},
        {"","ruby_tools_plus:handle",""},
        {"","ruby_tools_plus:handle",""},
    }
})