-- =========================
-- Alloy Fuser Machine
-- Ruby Tools+ v0.1.5dev
-- =========================

-- =========================
-- Alloy Recipes (machine-only)
-- =========================
local alloy_recipes = {
	{
		input = {
			"ruby_tools_plus:refined_ruby",
			"ruby_tools_plus:rubidium_lump",
		},
		output = "ruby_tools_plus:rubidium",
		time = 10, -- seconds
	}
}

-- =========================
-- Helper functions
-- =========================
local function get_formspec(progress, fuel)
	return
		"size[8,9]" ..
		"label[3,0;Alloy Fuser]" ..

		"list[current_name;src;2,1;2,1;]" ..
		"list[current_name;fuel;3,3;1,1;]" ..

		"image[3,2;1,1;default_furnace_fire_bg.png^[lowpart:" ..
		math.floor((fuel / 10) * 100) ..
		":default_furnace_fire_fg.png]" ..

		"image[2,2;1,1;gui_furnace_arrow_bg.png^[lowpart:" ..
		math.floor((progress / 10) * 100) ..
		":gui_furnace_arrow_fg.png]" ..

		"list[current_name;dst;5,1;3,3;]" ..
		"list[current_player;main;0,5;8,4;]" ..
		"listring[current_name;dst]" ..
		"listring[current_player;main]"
end

local function swap_node(pos, active)
	local node = minetest.get_node(pos)
	local name = active
		and "ruby_tools_plus:alloy_fuser_active"
		or  "ruby_tools_plus:alloy_fuser"

	if node.name ~= name then
		minetest.swap_node(pos, { name = name, param2 = node.param2 })
	end
end

local function stop_sound(meta)
	local h = meta:get_int("sound_handle")
	if h ~= 0 then
		minetest.sound_stop(h)
		meta:set_int("sound_handle", 0)
	end
end

local function start_sound(pos, meta)
	if meta:get_int("sound_handle") == 0 then
		local h = minetest.sound_play("default_furnace_active", {
			pos = pos,
			gain = 0.6,
			max_hear_distance = 16,
			loop = true,
		})
		meta:set_int("sound_handle", h)
	end
end

local function find_recipe(inv)
	for _, r in ipairs(alloy_recipes) do
		if inv:contains_item("src", r.input[1])
		and inv:contains_item("src", r.input[2]) then
			return r
		end
	end
	return nil
end

-- =========================
-- Machine logic
-- =========================
local function on_timer(pos)
	local meta = minetest.get_meta(pos)
	local inv = meta:get_inventory()

	local fuel = meta:get_int("fuel_left")
	local progress = meta:get_int("progress")

	if fuel <= 0 then
		meta:set_int("progress", 0)
		swap_node(pos, false)
		stop_sound(meta)
		meta:set_string("formspec", get_formspec(0, 0))
		meta:set_string("infotext", "Alloy Fuser (Idle)")
		return false
	end

	local recipe = find_recipe(inv)
	if not recipe then
		meta:set_int("progress", 0)
		swap_node(pos, false)
		stop_sound(meta)
		meta:set_string("infotext", "Alloy Fuser (Idle)")
		return true
	end

	start_sound(pos, meta)
	swap_node(pos, true)

	progress = progress + 1
	meta:set_int("progress", progress)

	if progress >= recipe.time then
		if inv:room_for_item("dst", recipe.output) then
			inv:remove_item("src", recipe.input[1])
			inv:remove_item("src", recipe.input[2])
			inv:add_item("dst", recipe.output)

			meta:set_int("progress", 0)
			meta:set_int("fuel_left", fuel - 1)
		end
	end

	meta:set_string("formspec", get_formspec(
		meta:get_int("progress"),
		meta:get_int("fuel_left")
	))
	meta:set_string("infotext", "Alloy Fuser (Active)")
	return true
end

local function on_construct(pos)
	local meta = minetest.get_meta(pos)
	local inv = meta:get_inventory()

	inv:set_size("src", 2)
	inv:set_size("fuel", 1)
	inv:set_size("dst", 9)

	meta:set_int("fuel_left", 0)
	meta:set_int("progress", 0)
	meta:set_int("sound_handle", 0)
	meta:set_string("formspec", get_formspec(0, 0))
	meta:set_string("infotext", "Alloy Fuser (Idle)")
end

local function allow_put(pos, listname, index, stack)
	if listname == "fuel" then
		return stack:get_name() == "bucket:bucket_lava" and 1 or 0
	end
	if listname == "src" then
		return stack:get_count()
	end
	return 0
end

local function on_put(pos, listname)
	if listname == "fuel" then
		local meta = minetest.get_meta(pos)
		local inv = meta:get_inventory()

		meta:set_int("fuel_left", 10)
		inv:set_stack("fuel", 1, "bucket:bucket_empty")
		minetest.get_node_timer(pos):start(1)
	end
end

-- =========================
-- Nodes
-- =========================
minetest.register_node("ruby_tools_plus:alloy_fuser", {
	description = "Alloy Fuser",
	tiles = {
		"alloy_fuser_side.png",
		"alloy_fuser_side.png",
		"alloy_fuser_side.png",
		"alloy_fuser_side.png",
		"alloy_fuser_side.png",
		"alloy_fuser.png",
	},
	paramtype2 = "facedir",
	groups = { cracky = 2 },
	sounds = default.node_sound_metal_defaults(),

	on_construct = on_construct,
	on_timer = on_timer,
	allow_metadata_inventory_put = allow_put,
	on_metadata_inventory_put = on_put,
	on_destruct = function(pos)
		stop_sound(minetest.get_meta(pos))
	end,
})

minetest.register_node("ruby_tools_plus:alloy_fuser_active", {
	description = "Alloy Fuser (Active)",
	tiles = {
		"alloy_fuser_side.png",
		"alloy_fuser_side.png",
		"alloy_fuser_side.png",
		"alloy_fuser_side.png",
		"alloy_fuser_side.png",
		"alloy_fuser_active.png",
	},
	paramtype2 = "facedir",
	light_source = 6,
	groups = { cracky = 2, not_in_creative_inventory = 1 },
	sounds = default.node_sound_metal_defaults(),
	drop = "ruby_tools_plus:alloy_fuser",

	on_timer = on_timer,
	allow_metadata_inventory_put = allow_put,
	on_metadata_inventory_put = on_put,
	on_destruct = function(pos)
		stop_sound(minetest.get_meta(pos))
	end,
})