-- =========================
-- Ruby Tools+ Texture Preload
-- Version: v0.1.5dev
-- =========================

local textures = {
    -- Items / materials
    "alloy.png",
    "gear.png",
    "handle.png",
    "refined_ruby.png",
    "rubidium.png",
    "rubidium_lump.png",
    "ruby.png",
    "ruby_dust.png",

    -- Cores
    "core.png",
    "heated_core.png",

    -- Coils
    "bronze_coil.png",
    "iron_coil.png",
    "ruby_coil.png",

    -- Nodes
    "ruby_block.png",
    "ruby_ore.png",
    "rubidium_ore.png",

    -- Tools
    "ruby_sword.png",
    "ruby_pickaxe.png",
    "ruby_axe.png",
    "ruby_shovel.png",
    "ruby_hoe.png",
}

-- Dummy invisible item used only to preload textures
minetest.register_on_mods_loaded(function()
    for _, tex in ipairs(textures) do
        minetest.register_craftitem(":ruby_tools_plus:_preload_" .. tex, {
            inventory_image = tex,
            groups = {not_in_creative_inventory = 1},
        })
    end
end)