# Uncraftable Recipes

**Author:** ReinPlayz  
**Version:** 0.04

---

## Overview

This is a small Minetest mod that adds shapeless crafting recipes to allow players to obtain items that are normally uncraftable in survival mode. It’s designed to be minimal, lightweight, and helpful in both survival and creative gameplay.

---

## Added Recipes

- **Water Source Block**  
  Shapeless recipe using a **Water Bucket**.  
  Output: `default:water_source`  
  → Bucket is returned empty.

- **River Water Source Block**  
  Shapeless recipe using a **River Water Bucket**.  
  Output: `default:river_water_source`  
  → Bucket is returned empty.

- **Lava Source Block**  
  Shapeless recipe using a **Lava Bucket**.  
  Output: `default:lava_source`  
  → Bucket is returned empty.

- **Grass Block (dirt_with_grass)**  
  Shapeless recipe using **Dirt**.  
  Output: `default:dirt_with_grass`

- **Ice Block**  
  Shapeless recipe using **Snow Block** and **Water Source**.  
  Output: `default:ice`  
  → Bucket is returned empty.

- **Book with Krams (Book + Flint)**  
  Shapeless recipe using **Book** and **Flint**.  
  Output: `default:book_written`

- **Papyrus**  
  Shapeless recipe using **Grass Block** and **Water Bucket**.  
  Output: `default:papyrus`  
  → Bucket is returned empty.

- **Obsidian Glass**  
  Shapeless recipe using **Obsidian** and **Glass**.  
  Output: `default:obsidian_glass`

- **Mossy Cobblestone**  
  Shapeless recipe using **Cobblestone** and **Papyrus**.  
  Output: `default:mossycobble`

- **Cactus**  
  Shapeless recipe using **Grass Block** and **Papyrus**.  
  Output: `default:cactus`

---

## Installation

1. Download or clone this mod into your Minetest `mods` folder.
2. Enable the mod in your world configuration.
3. Start the game and enjoy the new crafting possibilities!

---

## Notes

- All recipes are shapeless to simplify crafting.
- Buckets are returned empty after crafting.
- Intended as a lightweight quality-of-life improvement mod.
- More recipes may be added in future versions.

---

## License

MIT License

---

For feedback, ideas, or suggestions, reach out to the author: **ReinPlayz**