# Cube Hunter's Guide
```
._____     _               
|     |_ _| |_ ___         
|   --| | | . | -_|        
|_____|___|___|___|        
._____         _           
|  |  |_ _ ___| |_ ___ ___ 
|     | | |   |  _| -_|  _|
|__|__|___|_|_|_| |___|_|  
._____     _   _           
|   __|_ _|_|_| |___       
|  |  | | | | . | -_|      
|_____|___|_|___|___|      
                          
```
## Overview
This is the standard issue Cube Hunter's Guide.

NOTE: However, I (Rover) have added a few notes and warnings to help you out since I know this was going to be your first mission. 

First of all, welcome to the Wyrm Cube Hunter's Guild!

Second of all, we feel the need to clarify that your mission here is not to "mine" or "craft". It's to find and collect the Wyrm Cubes. You will be provided with everything you need to complete this mission and return home safely. If you do find yourself in a situation where you need to "mine" or "craft", please contact us immediately. We will send you a supply drop with additional supplied. In a worst case scenario, we will send you a **Transmuter**. 

NOTE: It's not looking like you will have "everything you need" this time. But I'll cover that later...

This guide will aid you in your mission. Read it carefully and don't misplace it. You never know when you might need it.

=======

## Mission Brief

### Basics
- Your mission is to find and collect Wyrm Cubes.
- They are scattered across the surface of the planet.
- Some may be very far away.
- Some may be hidden in caves or other hard to reach places.
- You will need to use the Wyrm Radar to find them.

### Wyrm Cubes Collection
- Once you find a Wyrm Cube, you need to collect it.
- Doing so may draw some "opposition" to your location.
- When a Wyrm Cube is collected, it will spawn a Wyrm Tower.
- There may be valuable loot at the top of the tower.
- Collecting this loot may be dangerous and is not critical to your mission.

### Wyrm Cube Assembly
- Once you have collected all the Wyrm Cubes on this planet, you will need to assemble them.
- This is done by placing them in a single stack inside a **Wyrm Chest** (acquired from the Wyrm Tower).
- Once you have placed all the Wyrm Cubes in the Wyrm Chest, we will evacuate you immediately and take over from there.

BIG NOTE: We may not be able to evacuate you this time... You might need to find the **Wyrm Sigil** and make it to the **Wyrm Portal** on your own. 

=======

## Wyrm Radar 
- This is your main tool for locating the Wyrm Cubes. 
- It works by detecting the cosmic radiation emitted by the cubes.
- When you use the Wyrm Radar, it will draw a trail pointing toward the nearest Wyrm Cube. 
- It also shows you the distance to the cube at the top of your HUD.

WARNING: We have reason to believe that an using the Wyrm Radar can attract monsters. Use with caution.

WARNING: I shouldn't be saying this, but we also have reason to believe that the cosmic radiation emitted by the Wyrm Cubes is possibly the "bad kind". We can give you rad treatment when you make it back.

=======

## Supply Drops
- Supply drops are crates that we send down to the surface to aid cube hunters. 
- They contain everything you need to find the Wyrm Cubes.

NOTE: This time these will have a random selection of supplies. I'll just send down whatever I can find.

=======

## Orientation
Aside from pointing out the direction of the Wyrm Cubes, you might find yourself needing to know your own location. 

### Wyrm GPS
- The **Wyrm GPS** will show you your coordinates in the top of your HUD when used. 
- It also allows you to use the mini-map with the 'Minimap' key.

### Binoculars
- The **Binoculars** are a great way to get a better view of the area. 
- You can use them to zoom in on distant objects. 

NOTE: Neither the Wyrm GPS or the Binoculars need to be your active item in order to provide their basic capabilities.

=======

## Radio
- You should be provided with a **Radio** in your supply drops.
- This is not for communication, but rather for listening to music.
- You can use the **Radio** to listen to music while you work.

NOTE: I'll do my best to send you one of these but no promises.

=======

## Meta Scanner
- The **Meta Scanner** is a device that will allow you to scan the environment.
- This is currently beta technology.
- You may find it useful in it's current state but it is a work in progress. 

=======

## Meta Vacuum
- The **Meta Vacuum** is a device that will allow you to collect items from the environment.
- Vacuumed items will be placed directly into your inventory.
- This can be much faster than mining by hand.
- Holding 'sneak' will engage a special mode which vacuums the block without "digging" it.

=======

## Capsules
- Capsules are a high tech storage device that can store items or entire structures.
- You should have been supplied with a wide variety of capsules in your supply drops. 
- To use an item of vehicle capsule, simply right click on the ground where you want to place it.
- To use a structure capsule, stand in the location you want to center the structure and right click.
- Vehicle capsules look like the vehicles they will spawn.
- Item and structure capsules look like small colored ovals.

NOTE: You were not supplied with a "wide variety" of capsules, but I tried to send down everything I could find. Remember to use the **Transmuter** if you need more **Supply Drops**. 

WARNING: Structure capsules are NO JOKE. They will place a whole structure right where you stand. This can wreak MAJOR havoc on the environment. We don't normally send these out to new recruits but I figured you might need some. 

=======

## Potions
- Potions are a great way to get a boost in your abilities.
- You can use them to heal yourself or to give you special powers.
- You should have been supplied with a few potions in your supply drops.
- To use a potion, simply right click on it in your hand.
- You will be warned a few seconds before the potion expires.

WARNING: Some potions can be pretty dangerous. Use them with caution. You don't want to end up 100 blocks in the air when one wears off. 

NOTE: I've heard that mixing potions can lead to strange effects. I have no idea what will happen if you mix them.

=======

## Transmuter
You may find yourself with a lot of items you don't need. Or a lack of items you do need. 

Back home you might be used to crafting items. But here we have much more advanced technology.

- Transmutation is the process of converting one item into another.
- You can use the **Transmuter** to convert items into tech parts.
- Place the items in the transmuter and it will convert them into tech parts.
- Items with higher values typically have higher conversion rates.
- For example, diamonds provide a higher rate than iron ingots.
- Via a process of repeated transmutation, you will synthesize a **Tech Chip**.
- Transmuting a **Tech Chip** will send it up to me and I will provide you with a **Supply Dropper**.
- The **Supply Dropper** is a device that will allow you to call down supply drops at will.

NOTE: The **Transmuter** isn't as complicated as it sounds. Just send me the **Tech Chips** and I'll turn them into cool stuff. 

NOTE: I sent you down with at least one **Yurt Capsule**. This is a structure capsule that will place a small house. This house will always have one **Transmuter** inside it.

NOTE: You can still craft items if you want to. No one is going to stop you. 

=======

## Vehicles
- Vehicles are a great way to get around quickly. 
- They are fast and can sometimes carry a lot of items.
- You should have been supplied with a few vehicle capsules in your supply drops.
- To use a vehicle capsule, simply right click on the ground where you want to place it.
- Right click on the vehicle to enter it. 
- Control methods vary by vehicle.

### Fuel
- Some vehicles require fuel to operate. 
- You can use biofuel from your supply drops to fuel the vehicles.
- Click on a vehicle with the biofuel in your hand to fill it. 

### Motorcycle
- Control: standard / look direction
- Fuel: solar (none)
- Returnable to inventory: yes
- The motorcycle goes different speeds depending on what surface it is on.
- The motorcycle is solar powered and does not require fuel to operate.
- It can operate underwater. NOTE: can you?.

NOTE: This is most cube hunter's go-to vehicle for ground transport. Cars don't work so well in places like this.  

### Hidroplane
- Control: sneak / jump
- Fuel: biofuel
- Returnable to inventory: no
- The hidroplane can fly and float.
- Right click on it to enter the hidroplane.
- Right click again to start the engine. 
- Here you can also access other information about the plane.
- Use `jump` to accelerate and `sneak` to decelerate.

WARNING: Hidroplanes are an excellent way to get around, but they can be very challenging to fly. These are for experienced pilots only.

### Airship
- Control: standard
- Fuel: solar (none)
- Returnable to inventory: yes
- The airship requires no fuel to operate, but it is fairly slow.
- It can fly and float.

### Motorboat
- Control: sneak / jump
- Fuel: biofuel
- Returnable to inventory: no
- Press 'aux' (e) to start the engine. 

### Hovercraft
- Control: standard / look
- Fuel: solar (none)
- Returnable to inventory: yes
- The hovercraft can not go up hills.

### Fishing Boat
More info coming soon!

### Sail Boat
More info coming soon!

