Structures = {}
Structures.simple_bom = {
	["."] = { name = "air" },
	a = { name = "air" },
	s = { name = "default:stone" },
	l = { name = "wool:white" },
	L = { name = "default:ladder_steel", rotate = 2 },
	w = { name = "default:wood" },
	W = { name = "default:acacia_wood" },
	o = { name = "default:glass" },
	t = { name = "default:torch_wall", rotate = 0 },
	T = { name = "default:torch_wall", rotate = 2 },
	b = { name = "beds:bed_bottom", rotate = 2 },
	B = { name = "beds:bed_top", rotate = 2 },
	h = { name = "default:bookshelf", rotate = 3 },
	c = { name = "default:chest", rotate = 2 },
	f = { name = "stairs:slab_wood" },
	F = { name = "flowers:tulip" },
	n = { name = "default:fence_acacia_wood" },
	g = { name = "doors:gate_acacia_wood_closed", rotate = 1 },
	d = { name = "doors:door_glass_a", rotate = 2 },
	D = { name = "doors:door_glass_a", rotate = 3 },
	r = { name = "default:dirt" },
}
Structures.yurt_bom = {
	["."] = { name = "air" },
	a = { name = "air" },
	s = { name = "default:stone" },
	l = { name = "wool:white" },
	L = { name = "default:ladder_steel", rotate = 2 },
	w = { name = "default:wood" },
	W = { name = "default:acacia_wood" },
	o = { name = "default:glass" },
	t = { name = "default:torch_wall", rotate = 0 },
	T = { name = "default:torch_wall", rotate = 2 },
	b = { name = "beds:bed_bottom", rotate = 2 },
	B = { name = "beds:bed_top", rotate = 2 },
	h = { name = "default:bookshelf", rotate = 3 },
	c = { name = "default:chest", rotate = 0 },
	f = { name = "stairs:slab_wood" },
	F = { name = "flowers:tulip" },
	n = { name = "default:fence_acacia_wood" },
	g = { name = "doors:gate_acacia_wood_closed", rotate = 1 },
	d = { name = "doors:door_glass_a", rotate = 2 },
	D = { name = "doors:door_glass_a", rotate = 3 },
	r = { name = "default:dirt" },
	p = { name = "wyrm_cube:lamp_small", rotate = 0 },
	x = { name = "wyrm_cube:transmuter", rotate = 0 },
}
Structures.yurt = {
	[[
W W W W W W W W W
W W W W W W W W W
W W W W W W W W W
W W W W W W W W W
W W W W W W W W W
W W W W W W W W W
W W W W W W W W W
]],
	[[
W l l l l l l l W
l c a a x a a a l
l a a a a a a a l
l b a a a a a a l
l B a a a a a a l
W l l l d l l l W
a p a a a a a p a
]],
	[[
W l o o l o o l W
l a a a a a a a l
o a a a a a a a o
o a a a a a a a o
l a a a a a a a l
W l o l a l o l W
a a a a a a a a a
]],
	[[
W l l l l l l l W
l a a a a a a a l
l a a a a a a a l
l a a a a a a a l
l a a a a a a a l
W l l l l l l l W
a a a a a a a a a
]],
	[[
W l l l l l l l W
l a a a a a a a l
l a a a a a a a l
l a a a a a a a l
l a a a a a a a l
W l l l l l l l W
a a a p a p a a a
]],
	[[
a W W W W W W W a
W l l l l l l l W
W l l l l l l l W
W l l l l l l l W
W l l l l l l l W
a W W W W W W W a
a a a a a a a a a
]],
}
Structures.house_a = {
	[[
W s s s s s s s W
s s s s s s s s s
s s s s s s s s s
s s s s s s s s s
s s s s s s s s s
s s s s s s s s s
W s s s s s s s W
]],
	[[
W s s s s s s s W
s L a a a a a W s
s a a a a a a a s
s a a a a a a a s
s a a a a a a a s
s W a a c a a W s
W s s s s s s s W
]],
	[[
W s s s s s s s W
s L T a a a T W s
s a a a a a a a s
s a a a a a a a s
s a a a a a a a s
s W t a a a t W s
W s s s s s s s W
]],
	[[
W s s s s s s s W
s L a a a a a W s
s a a a a a a a s
s a a a a a a a s
s a a a a a a a s
s W a a a a a W s
W s s s s s s s W
]],
	[[
W s s s s s s s W
s L a a a a a W s
s a a a a a a a s
s a a a a a a a s
s a a a a a a a s
s W a a a a a W s
W s s s s s s s W
]],
	[[
W s s s s s s s W
s L w w w w w w s
s w w w w w w w s
s w w w w w w w s
s w w w w w w w s
s w w w w w w w s
W s s s s s s s W
]],
	[[
s s s s s s s s s
s L w w w w c w s
s w w w w w w w s
s w w w w w w w s
s w w w w r r r s
s w w w w r r r s
s s s s s s s s s
]],
	[[
W l l l l l l l W
l L a a a a a b l
l a a a a a f B l
l a a a h l l l W
l a a a l F F F g
W l d l W F F F n
a a a a n n n n n
]],
	[[
W l o o l o o l W
l a a a a a a a o
o a a a a a a a o
o a a a h o o l W
l t a t l a a a a
W l a l W a a a a
a T a T a a a a a
]],
	[[
W l l l l l l l W
l a a a a a a a l
l a a a a a a a l
l a a a h l l l W
l a a a l a a a a
W l l l W a a a a
a a a a a a a a a
]],
	[[
w w w w w w w w w
w w w w w w w w w
w w o w w w w w w
w w w w w w w w w
w w w w w f f f f
w w w w w a a a a
f f f f f a a a a
]],
}

Structures.make_bp_tower = function(section_height)
	section_height = section_height or 8
	local bp = {
		[[
s s s s s s s s s
s s s s s s s s s
s s s s s s s s s
s s s s s s s s s
s s s s s s s s s
s s s s s s s s s
s s s s s s s s s
s s s s s s s s s
s s s s s s s s s
]],
	}
	table.insert(
		bp,
		[[
. . . . . . . . .
. . . . . . . . .
. . W s s s W . .
. . s . L . s . .
. . s . . . s . .
. . s . . . s . .
. . W s d s W . .
. . . . . . . . .
. . . . . . . . .
]]
	)
	table.insert(
		bp,
		[[
. . . . . . . . .
. . . . . . . . .
. . W s s s W . .
. . s . L . s . .
. . s . . . s . .
. . s . . . s . .
. . W s a s W . .
. . . . . . . . .
. . . . . . . . .
]]
	)
	local section1a = [[
. . . . . . . . .
. . . . . . . . .
. . W s s s W . .
. . s . L . s . .
. . s . . . s . .
. . s . . . s . .
. . W s s s W . .
. . . . . . . . .
. . . . . . . . .
]]
	local section1b = [[
. . . . . . . . .
. . . . . . . . .
. . W s s s W . .
. . s T L T s . .
. . o . . . o . .
. . s . . . s . .
. . W s o s W . .
. . . . . . . . .
. . . . . . . . .
]]
	local section2a = [[
. . . . . . . . .
. W s s s s s W .
. s W s s s W s .
. s s . L . s s .
. s s . . . s s .
. s s . . . s s .
. s W s s s W s .
. W s s s s s W .
. . . . . . . . .
]]
	local section2b = [[
. . . . . . . . .
. W s s s s s W .
. s W s s s W s .
. s s T L T s s .
. o . . . . . o .
. s s . . . s s .
. s W s . s W s .
. W s s o s s W .
. . . . . . . . .
]]
	local section3a = [[
W s s s s s s s W
s W s s s s s W s
s s W s s s W s s
s s s . L . s s s
s s s . . . s s s
s s s . . . s s s
s s W s s s W s s
s W s s s s s W s
W s s s s s s s W
]]
	local section3b = [[
W s s s s s s s W
s W s s s s s W s
s s W s s s W s s
s s s T L T s s s
o . . . . . . . o
s s s . . . s s s
s s W s . s W s s
s W s s . s s W s
W s s s o s s s W
]]
	for _ = 1, section_height do
		table.insert(bp, section1a)
		table.insert(bp, section1b)
	end
	for _ = 1, section_height do
		table.insert(bp, section2a)
		table.insert(bp, section2b)
	end
	for _ = 1, section_height do
		table.insert(bp, section3a)
		table.insert(bp, section3b)
	end

	table.insert(
		bp,
		[[
W W s s s s s W W
W s s s s s s s W
s s s s s s s s s
s s s s L s s s s
s s s s s s s s s
s s s s s s s s s
s s s s s s s s s
W s s s s s s s W
W W s s s s s W W
]]
	)
	table.insert(
		bp,
		[[
w w w w w w w w w
w . T . . . T . w
w . . . s . . . w
w . . . L . . . w
w . . . . . . . w
w . . . . . . . w
w . . . . . . . w
w . t c . c t . w
w w w w w w w w w
]]
	)

	return bp
end
