# Contributing to Minetest Emotions Mod

We welcome and appreciate your interest in contributing to the Minetest Emotions Mod. This document provides guidelines for contributing to the mod and ensuring a smooth collaboration process.

## How to Contribute

### Reporting Bugs or Suggesting Enhancements

- **Use the Issue Tracker:** If you find a bug or have a suggestion for an enhancement, please use our GitHub issue tracker. Be as specific as possible in your report.
- **Check Existing Issues:** Before submitting a new issue, please check for existing issues to avoid duplicates.

### Making Changes

- **Fork the Repository:** Start by forking the repository on GitHub.
- **Create a Branch:** Create a branch in your fork for your changes. Use a clear and descriptive name for your branch.
- **Make Your Changes:** Make your changes in your branch. Ensure your code adheres to the existing style to maintain consistency.
- **Test Your Changes:** Test your changes to ensure they work as expected and don’t break existing functionality.

### Submitting Changes

- **Create a Pull Request:** Once you’re satisfied with your changes, create a pull request against the original repository. Provide a clear and detailed description of your changes and the reasons for them.
- **Code Review:** Your pull request will be reviewed by the maintainers. Be open to discussion and feedback.

## Development Guidelines

- **Code Style:** Follow the established code style of the project.
- **Commit Messages:** Write clear and concise commit messages. Each commit message should describe what was changed and why.

## License

By contributing to this project, you agree that your contributions will be licensed under its MIT License and artwork can be released as Creative Commons Zero.

## Questions or Need Help?

If you have questions or need help, feel free to open an issue in the issue tracker with your question.
