# Periodic Elements Mod for OpenLearningQuest

The Periodic Elements Mod for Minetest, designed specifically for OpenLearningQuest, brings the fascinating world of chemistry to your virtual sandbox! This mod introduces elemental blocks representing the first two elements of the periodic table: Hydrogen and Helium. As part of our ongoing educational initiative, we plan to expand the mod to include all 118 elements.

## Features

1. Hydrogen Block
2. Helium Block

## Installation

1. Clone or download this repository.
2. Extract the contents into your Minetest mods folder.

## Usage

1. Launch Minetest and create a new world.
2. Enable the "Periodic Elements" mod in the world configuration settings.
3. Find Hydrogen and Helium blocks in the creative inventory.

## Educational Features

### Instructions for Parents and Guardians

Parents and guardians can use this mod as a fun and interactive way to introduce basic chemistry concepts to children. Engage with your child as they explore the elements, and encourage discussions about the properties of Hydrogen and Helium.

### Age Groups/Levels

- **Suitable for ages 6 and above:**
  - Provides a foundational understanding of basic chemistry concepts.
  - Encourages creativity through building with elemental blocks.
  - Offers a unique perspective on chemistry in a creative context.

### Curriculum Alignment

While not aligned with a specific curriculum, this mod supports general science education goals, providing an introduction to the periodic table and fundamental properties of elements.

### Educational Goals

This mod aims to foster an early interest in science, encouraging exploration and curiosity about the world around us. Through interactive gameplay, it introduces basic chemistry concepts in an accessible and engaging manner.

### Instructional Use

#### Chemistry Lessons

This mod serves as an excellent educational tool for chemistry lessons, especially when introducing the periodic table of elements. Teachers can use the blocks to visually represent elements, with each block featuring the element's symbol in the center and the atomic number displayed on the top left.

1. **Elemental Exploration:**
   - Encourage students to explore the in-game periodic table and interact with the blocks representing different elements.
   - Discuss the unique properties of each element, such as their atomic structure, reactivity, and common uses.
2. **Periodic Trends:**
   - Challenge students to identify patterns within groups and periods.

#### Creative Assignments

1. **Element Showcase:**
   - Assign students a project to create a showcase of different elements using the mod.
   - Each student can be responsible for researching and presenting information about a specific element, then building its block in the game.

2. **Molecular Modeling:**
   - Explore molecular structures by having students combine different elements to create simple compounds or molecules within the game.
   - Discuss the chemical reactions and properties of the resulting structures.

#### Interactive Assessments

1. **Element Identification Quiz:**
   - Use the mod as a tool for quizzes or assessments where students must identify elements based on their symbols and atomic numbers within the game.
   - Enhance engagement by turning it into a timed challenge.

2. **Periodic Table Scavenger Hunt:**
   - Create a fun scavenger hunt within the game where students must locate specific elements based on given clues.
   - Reinforce their understanding of the periodic table's layout and organization.

#### Future Expansion

1. **Stay Updated:**
   - Keep an eye on future updates as more elements are added to the mod.
   - Discuss new elements and their significance in the context of the periodic table.

2. **Collaborative Element Building:**
   - Foster collaboration by assigning groups of students to research and propose designs for upcoming elements to be added to the mod.
   - Encourage creative and accurate representation of each element.

## Feedback and Contributions

We welcome any feedback, suggestions, or contributions! Feel free to [open an issue](https://github.com/OpenLearningQuest/minetest_periodic_elements/issues) or submit a pull request to improve the educational experience offered by this mod.

## Credits

- Mod developed by Victor Resende

## License

This mod is licensed under the [MIT License](LICENSE.txt).
All assets for Minetest Periodic Elements by Victor Andrade Resende are marked with CC0 1.0 
