local ent_name, ent_def = advanced_fight_lib.get_entity({"mobs_monster:tree_monster"})

local parts = {
	head = {
		box = {x_min = -0.2, y_min = 0.45, z_min = -0.1,
					 x_max = 0.2, y_max = 0.7, z_max = 0.3},
		part_of_health = 0.8,
		damage_multiplier = 1.25,
		miss_chance = 0.2,
		miss_chance_angles = {
			[0]=0.2,
			[60]=0.2,
			[90]=0.1,
			[135]=0.0,
			[180]=0.0
		},
		cb_get_miss_chance = advanced_fight_lib.calculate_get_miss_chance,
		values = {
			["mobs:walk_chance"] = {
					name = "head",
					threshold_start = 0.2,
					threshold_peak = 0.8,
					base_value = 1.0,
					peak_value = 0.4,
					over_value = 0.1,
					curve = 1,
					value = 1,
					rule = "multiply",
					priority = 100,
				},
			["mobs:stand_chance"] = {
					name = "head",
					threshold_start = 0.2,
					threshold_peak = 0.8,
					base_value = 1.0,
					peak_value = 1.5,
					over_value = 2.0,
					curve = 1,
					value = 1,
					rule = "multiply",
					priority = 100,
				},
			["mobs:attack_chance"] = {
					name = "head",
					threshold_start = 0.2,
					threshold_peak = 0.8,
					base_value = 1.0,
					peak_value = 3.0,
					over_value = 9.0,
					curve = 1,
					value = 1,
					rule = "multiply",
					priority = 100,
				},
			["mobs:attack_patience"] = {
					name = "head",
					threshold_start = 0.2,
					threshold_peak = 0.8,
					base_value = 1.0,
					peak_value = 0.5,
					over_value = 0.25,
					curve = 1,
					value = 1,
					rule = "multiply",
					priority = 100,
				},
		},
		effects = {
			["eye_hit"] = advanced_fight_lib.create_point_hit_effect({
					points = {
						{x=0.75, y=0.45},
						{x=0.35, y=0.45},
					},
					points_radius = 1/12,
					points_area = 1/144,
					points_axis = "z+",
					points_max_health = 0.5,
					part_damage_key = "eyes_damage",
					name = "head",
					values = {
						["mobs:view_range"] = {
								name = "head",
								part_damage_key = "eyes_damage",
								cb_calculate_damage = advanced_fight_lib.point_hit_effect_view_range_calculate_damage,
								threshold_start = 1,
								threshold_peak = 2,
								base_value = 1.0,
								peak_value = 0.3,
								over_value = 0.2,
								curve = 1,
								value = 1,
								rule = "multiply",
								priority = 100,
						},
				},
				texture_hit_point = "advanced_fight_tree_monster_hit_eye_%s.png",
				effects_group_label = "advanced_fight_eye_hit_effects",
				cb_on_update = advanced_fight_lib.mobs.point_hit_effects_group_on_update,
			}),
		},
		effects_group_label = "advanced_fight_head_hit_effects",
		on_hit = advanced_fight_lib.entity_on_hit,
	},
	torso = {
		box = {x_min = -0.2, y_min = -0.6, z_min = -0.1,
					 x_max = 0.2, y_max = 0.45, z_max = 0.3},
		part_of_health = 1,
		damage_multiplier = 1,
		values = {},
		effects_group_label = "advanced_fight_torso_hit_effects",
		on_hit = advanced_fight_lib.entity_on_hit,
	},
	leg_one = {
		box = {x_min = -0.4, y_min = -1, z_min = -0.3,
					 x_max = -0.2, y_max = -0.5, z_max = 0},
		part_of_health = 0.175,
		damage_multiplier = 0.7,
		miss_chance = 0.4,
		miss_chance_angles = {
			[0]=0.4,
			[60]=0.4,
			[90]=0.3,
			[135]=0.2,
			[180]=0.2
		},
		cb_get_miss_chance = advanced_fight_lib.calculate_get_miss_chance,
		values = {
			["mobs:walk_velocity"] = {
					name = "leg_one",
					threshold_start = 0.4,
					threshold_peak = 1.0,
					base_value = 1.0,
					peak_value = 0.5,
					over_value = 0.25,
					curve = 1,
					value = 1,
					rule = "multiply",
					priority = 100,
				},
			["mobs:run_velocity"] = {
					name = "leg_one",
					threshold_start = 0.2,
					threshold_peak = 0.8,
					base_value = 1.0,
					peak_value = 0.3,
					over_value = 0.15,
					curve = 1,
					value = 1,
					rule = "multiply",
					priority = 100,
				},
		},
		effects_group_label = "advanced_fight_leg_one_hit_effects",
		on_hit = advanced_fight_lib.entity_on_hit,
	},
	leg_two = {
		box = {x_min = -0.4, y_min = -1, z_min = 0.2,
					 x_max = -0.2, y_max = -0.5, z_max = 0.5},
		part_of_health = 0.175,
		damage_multiplier = 0.7,
		miss_chance = 0.4,
		miss_chance_angles = {
			[0]=0.4,
			[60]=0.4,
			[90]=0.3,
			[135]=0.2,
			[180]=0.2
		},
		cb_get_miss_chance = advanced_fight_lib.calculate_get_miss_chance,
		values = {
			["mobs:walk_velocity"] = {
					name = "leg_two",
					threshold_start = 0.4,
					threshold_peak = 1.0,
					base_value = 1.0,
					peak_value = 0.5,
					over_value = 0.25,
					curve = 1,
					value = 1,
					rule = "multiply",
					priority = 100,
				},
			["mobs:run_velocity"] = {
					name = "leg_two",
					threshold_start = 0.2,
					threshold_peak = 0.8,
					base_value = 1.0,
					peak_value = 0.3,
					over_value = 0.15,
					curve = 1,
					value = 1,
					rule = "multiply",
					priority = 100,
				},
		},
		effects_group_label = "advanced_fight_leg_two_hit_effects",
		on_hit = advanced_fight_lib.entity_on_hit,
	},
	leg_three = {
		box = {x_min = 0.2, y_min = -1, z_min = -0.3,
					 x_max = 0.4, y_max = -0.5, z_max = 0},
		part_of_health = 0.175,
		damage_multiplier = 0.7,
		miss_chance = 0.4,
		miss_chance_angles = {
			[0]=0.4,
			[60]=0.4,
			[90]=0.3,
			[135]=0.2,
			[180]=0.2
		},
		cb_get_miss_chance = advanced_fight_lib.calculate_get_miss_chance,
		values = {
			["mobs:walk_velocity"] = {
					name = "leg_three",
					threshold_start = 0.4,
					threshold_peak = 1.0,
					base_value = 1.0,
					peak_value = 0.5,
					over_value = 0.25,
					curve = 1,
					value = 1,
					rule = "multiply",
					priority = 100,
				},
			["mobs:run_velocity"] = {
					name = "leg_three",
					threshold_start = 0.2,
					threshold_peak = 0.8,
					base_value = 1.0,
					peak_value = 0.3,
					over_value = 0.15,
					curve = 1,
					value = 1,
					rule = "multiply",
					priority = 100,
				},
		},
		effects_group_label = "advanced_fight_leg_three_hit_effects",
		on_hit = advanced_fight_lib.entity_on_hit,
	},
	leg_four = {
		box = {x_min = 0.2, y_min = -1, z_min = 0.2,
					 x_max = 0.4, y_max = -0.5, z_max = 0.5},
		part_of_health = 0.175,
		damage_multiplier = 0.7,
		miss_chance = 0.4,
		miss_chance_angles = {
			[0]=0.4,
			[60]=0.4,
			[90]=0.3,
			[135]=0.2,
			[180]=0.2
		},
		cb_get_miss_chance = advanced_fight_lib.calculate_get_miss_chance,
		values = {
			["mobs:walk_velocity"] = {
					name = "leg_four",
					threshold_start = 0.4,
					threshold_peak = 1.0,
					base_value = 1.0,
					peak_value = 0.5,
					over_value = 0.25,
					curve = 1,
					value = 1,
					rule = "multiply",
					priority = 100,
				},
			["mobs:run_velocity"] = {
					name = "leg_four",
					threshold_start = 0.2,
					threshold_peak = 0.8,
					base_value = 1.0,
					peak_value = 0.3,
					over_value = 0.15,
					curve = 1,
					value = 1,
					rule = "multiply",
					priority = 100,
				},
		},
		effects_group_label = "advanced_fight_leg_four_hit_effects",
		on_hit = advanced_fight_lib.entity_on_hit,
	}
}

if ent_def then
	local hitgroup_name = "mobs_monster:tree_monster"
	hitboxes_lib.register_hitboxes(hitgroup_name, parts)

	ent_def.hitgroup_name = hitgroup_name
	advanced_fight_lib.mobs.replace_do_punch(ent_def)

	ent_def._attack_data = {
		hit_range = ent_def.reach,
		hit_box = hitboxes_lib.collisionbox_to_box({-0.2, -0.1, -0.2, 0.2, 0.1, 0.2}),
		hit_area = 0.4*0.2,
		punch_offset = vector.new(0, -0.4, 0),
		target_offset = vector.new(0, 1.3, 0),
		horizontal_inaccuracy = 5,
		vertical_inaccuracy = 10,
	}
end
