# Luanti mod `geodesy`

A mod that adds surveying tools for measuring distances in your world.

## Source code:

Copyright (c) 2025 SFENCE
MIT - check LICENSE file

## License of media (textures, sounds and models):
CC BY-SA 4.0 - check LICENSE file

Copyright (c) 2025 SFENCE (CC BY-SA 4.0):
All textures not mentioned below.

## How to use (player guide)

### What you need

This mod adds two items for measuring distances:
- **Levelling Staff** (measuring rod) - a tall striped pole you place at the target location
- **Theodolite** (viewing instrument) - a tool you use to look at the staff and measure distance

Craft these items using the recipes defined in the mod (check your crafting guide).

### Quick start guide

**Basic measurement in 3 simple steps:**

1. **Place the staff at your target**
   - Take the levelling staff and place it at the location you want to measure to
   - The staff consists of two parts: place the bottom part first, then right-click it with the top part to complete the staff
   - You should see a tall pole with colored stripes (ticks)

2. **Stand at your starting point and use the theodolite**
   - Go to the location you want to measure from
   - Hold the theodolite and right-click (place/use button) to activate zoom mode
   - You'll see a magnified view with crosshairs on the screen
   - Look at the staff you placed earlier

3. **Count the colored stripes (ticks)**
   - Count how many colored stripes on the staff are visible between the crosshair lines
   - More ticks = farther distance
   - Fewer ticks = closer distance
   - Right-click again to exit zoom mode

### Understanding the measurements

The theodolite works on a simple principle: **objects appear smaller when they're farther away**.

- If you count **6 ticks** at a distance you know is **20 blocks**, and later count **12 ticks**, the new distance is **40 blocks** (double the ticks = double the distance)
- If you count **6 ticks** at **20 blocks**, and later count **3 ticks**, the new distance is **10 blocks** (half the ticks = half the distance)

**Formula for calculating distance:**
```
distance = known_distance × (ticks_now / ticks_at_known_distance)
```

### Calibration (optional but recommended)

For more accurate measurements, calibrate first:

1. Place a staff at a known distance (for example, count 20 blocks from where you're standing)
2. Use the theodolite and count the ticks - let's say you see **6 ticks**
3. Now you have your reference: **6 ticks = 20 blocks**
4. For any future measurement, use: `distance = 20 × (new_ticks / 6)`

**Example:** If you later see 9 ticks, the distance is: 20 × (9 / 6) = 30 blocks

### Tips for best results

- **Stand at the same height** as the staff for consistent measurements
- **Use flat ground** when possible - hills can affect accuracy
- **Use round numbers** for your reference distance (10, 20, 50 blocks) - makes math easier
- **Place the staff precisely** on the target block
- **The measurement works the same** regardless of your screen resolution

## Test environment command

To quickly create a set of test stations use the chat command:

    /geodesy_create_test_place <count> <distance>

- Example: `/geodesy_create_test_place 4 20` will create 4 stations at 20, 40, 60 and 80 nodes from your current position in the direction you are looking.
- Privilege: requires the `creative` privilege.
- The command checks for the `signs_lib` mod and will abort with an error if it is not enabled.
- The node under your current position will be changed to a gold block and each test station consists of the down and up staff nodes plus a sign showing the distance.

Recommendation: run the command on a flat map (use a flat map generator) to avoid terrain interfering with the test stations.

## Found bug? Want improvements?
If you foun bug, have improvment idea etc, use https://github.com/sfence/geodesy/issues . Author is opened to help via PR, but strongly recommend to consult improvment idea first via issue or different comunication platform.

