local S = geodesy.translate

core.register_chatcommand("geodesy_create_test_place", {
    params = "<count> <distance>",
    description = S("Create a set of test places with geodesy nodes"),
    privs = {creative=true},
    func = function(name, param)
        local player = core.get_player_by_name(name)
        if not player then
            return false, S("Player not found")
        end

        -- parse params
        local count_s, dist_s = param:match("^(%S+)%s*(%S*)")
        local count = tonumber(count_s)
        local dist = tonumber(dist_s)
        if not count or not dist or count < 1 or dist <= 0 then
            return false, S("Usage: /geodesy_create_test_place <count> <distance>")
        end

        -- check signs_lib
        if not core.get_modpath("signs_lib") then
            return false, S("Required mod 'signs_lib' is not enabled")
        end

        local sign_node_name = "default:sign_wood_yard"

        local pos = player:get_pos()
        local base_y = math.floor(pos.y) + 1

        -- mark node under player as gold block
        local below = { x = math.floor(pos.x), y = base_y - 1, z = math.floor(pos.z) }
        core.set_node(below, { name = "default:goldblock" })

        -- place stations in player's look direction (horizontal)
        local dir = player:get_look_dir()
        local hdir = { x = dir.x, y = 0, z = dir.z }
        local len = math.sqrt(hdir.x * hdir.x + hdir.z * hdir.z)
        if len == 0 then
            hdir.x, hdir.z = 1, 0
            len = 1
        end
        hdir.x = hdir.x / len
        hdir.z = hdir.z / len
			  local orth_dir = { x = -hdir.z, y = 0, z = hdir.x } -- 90 degree rotation

        for i = 1, count do
            -- spread stations perpendicular to look direction so they don't overlap
            local spread = (i - (count + 1) / 2)
            local perp = spread -- perpendicular offset in nodes
            local radial = dist * i
            local along = math.sqrt(math.max(0, radial * radial - perp * perp))

            local fx = pos.x + hdir.x * along + orth_dir.x * perp
            local fz = pos.z + hdir.z * along + orth_dir.z * perp
            local station_x = math.floor(fx + 0.5)
            local station_z = math.floor(fz + 0.5)

            local down_pos = { x = station_x, y = base_y,     z = station_z }
            local up_pos   = { x = station_x, y = base_y + 1, z = station_z }
            local sign_pos = { x = station_x, y = base_y + 2, z = station_z }

            core.set_node(down_pos, { name = "geodesy:levelling_staff_down" })
            core.set_node(up_pos,   { name = "geodesy:levelling_staff_up" })

            -- compute sign rotation (param2 0..3) so the sign faces the player if possible
            local dx = pos.x - fx
            local dz = pos.z - fz
            local sign_dir
            if math.abs(dx) >= math.abs(dz) then
                -- more east/west
                if dx >= 0 then
                    sign_dir = 3
                else
                    sign_dir = 1
                end
            else
                -- more north/south
                if dz >= 0 then
                    sign_dir = 2
                else
                    sign_dir = 0
                end
            end
            core.set_node(sign_pos, { name = sign_node_name, param2 = sign_dir })

            -- set sign text (try common metadata keys)
            local meta = core.get_meta(sign_pos)
            local text = tostring(dist * i)
            -- common keys used by sign mods: "text" and "infotext"
            meta:set_string("text", text)
            meta:set_string("infotext", text)

						signs_lib.update_sign(sign_pos) -- needed for some sign mods
        end

        return true, S("Test places created")
    end,
})