
local S = geodesy.translate


-- Runtime-only per-player state (not persisted across server restarts)
local players_state = {}

local function enable_zoom_for(player)
	if not player then return end
	local name = player:get_player_name()
	local state = players_state[name] or {}

	-- Add HUD overlay if available
	if player.hud_add and not state.hud then
		local hud_def = {
			type = "image",
			position = {x = 0, y = 0},
			offset = {x = 0, y = 0},
			-- Negative scale used by some clients to simulate zoom
			scale = {x = -100, y = -100},
			text = "geodesy_theodolite_screen.png",
			alignment = {x = 1, y = 1},
			z_index = 1000,
		}
		local hid = player:hud_add(hud_def)
		if hid then
			state.hud = hid
		end
	end

	-- Try to set FOV if supported (smaller value = zoomed in)
	if player.set_fov then
		player:set_fov(100/24, false, 0.1)
		state.zoomed = true
	end

	players_state[name] = state
end

local function disable_zoom_for(player)
	if not player then return end
	local name = player:get_player_name()
	local state = players_state[name]
	if not state then return end

	if state.hud and player.hud_remove then
		player:hud_remove(tonumber(state.hud))
		state.hud = nil
	end

	if state.zoomed then
		player:set_fov(0)
		state.zoomed = nil
	end

	players_state[name] = nil
end

local function toggle_theodolite(player)
	if not player then return end
	local name = player:get_player_name()
	local state = players_state[name]
	if state then
		disable_zoom_for(player)
	else
		enable_zoom_for(player)
	end
end

-- Cleanup when player leaves to avoid stale HUD ids
core.register_on_leaveplayer(function(player)
	if not player then return end
	local name = player:get_player_name()
	if players_state[name] then
		disable_zoom_for(player)
	end
end)

core.register_tool("geodesy:theodolite", {
	description = S("Theodolite"),
	inventory_image = "geodesy_theodolite_inv.png",
	on_secondary_use = function(itemstack, user, pointed_thing)
		toggle_theodolite(user)
		return itemstack
	end,
	on_place = function(itemstack, user, pointed_thing)
		toggle_theodolite(user)
		return itemstack
	end,
})

