local S = geodesy.translate

-- node box {x=0, y=0, z=0}
local node_box_down = {
	type = "fixed",
	fixed = {
		{-0.25,-0.5,-0.25,0.25,-0.375,0.25},
		{-0.125,-0.375,-0.125,0.125,0.5,0.125},
	},
}

-- node box {x=0, y=0, z=0}
local node_box_up = {
	type = "fixed",
	fixed = {
		{-0.1875,-0.5,-0.1875,-0.0625,-0.375,-0.0625},
		{0.0625,-0.5,-0.1875,0.1875,-0.375,-0.0625},
		{-0.0625,-0.5,-0.125,0.0625,0.5,0.125},
		{-0.125,-0.375,-0.125,-0.0625,0.5,0.125},
		{0.0625,-0.375,-0.125,0.125,0.5,0.125},
		{-0.125,-0.5,-0.0625,-0.0625,-0.375,0.1875},
		{0.0625,-0.5,-0.0625,0.125,-0.375,0.1875},
		{-0.1875,-0.5,0.0625,-0.125,-0.375,0.1875},
		{0.125,-0.5,0.0625,0.1875,-0.375,0.1875},
	},
}

core.register_node("geodesy:levelling_staff_down", {
	description = S("Levelling Staff"),
	tiles = {"default_wood.png", "geodesy_levelling_staff_down.png"},
	drawtype = "mesh",
	mesh = "geodesy_levelling_staff_down.obj",
	collision_box = node_box_down,
	selection_box = node_box_down,
	groups = {cracky=3, oddly_breakable_by_hand=3},
	sounds = default.node_sound_wood_defaults(),
	paramtype = "light",
})

core.register_node("geodesy:levelling_staff_up", {
	description = S("Levelling Staff"),
	tiles = {"default_steel_block.png", "geodesy_levelling_staff_up.png"},
	drawtype = "mesh",
	mesh = "geodesy_levelling_staff_up.obj",
	collision_box = node_box_up,
	selection_box = node_box_up,
	groups = {cracky=3, oddly_breakable_by_hand=3, attached_node=1},
	sounds = default.node_sound_wood_defaults(),
	paramtype = "light",
	-- only allow placing the upper part on top of the matching lower part
	on_place = function(itemstack, placer, pointed_thing)
		if not pointed_thing or pointed_thing.type ~= "node" then
			return itemstack
		end
		local under = pointed_thing.under
		local player_name = placer and placer:get_player_name() or ""
		-- ensure the node under the pointed position is the down-part
		local n = core.get_node(under)
		if not n or n.name ~= "geodesy:levelling_staff_down" then
			return itemstack
		end
		-- target position is exactly above the down part
		local pos = { x = under.x, y = under.y + 1, z = under.z }
		local existing = core.get_node(pos)
		-- check if space is available (air or buildable_to)
		local can_place = false
		if existing and (existing.name == "air") then
			can_place = true
		else
			local reg = core.registered_nodes[existing and existing.name or ""]
			if reg and reg.buildable_to then
				can_place = true
			end
		end
		if not can_place then
			return itemstack
		end
		-- protection check
		if core.is_protected and core.is_protected(pos, player_name) then
			return itemstack
		end
		-- place the up node exactly on top of the down node
		core.set_node(pos, { name = "geodesy:levelling_staff_up" })
		-- play placement sound if available
		if core.sound_play then
			core.sound_play("default_place_node", { pos = pos, gain = 0.3 })
		end
		if not core.is_creative_enabled(player_name) then
			-- take one item from stack if not in creative mode
			itemstack:take_item(1)
		end
		return itemstack
	end,
})