
paleotest.dinosaurs = {
    brachiosaurus = "Brachiosaurus", carnotaurus = "Carnotaurus",
    pteranodon = "Pteranodon", quetzalcoatlus = "Quetzalcoatlus", 
    sarcosuchus = "Sarcosuchus", spinosaurus = "Spinosaurus", 
    stegosaurus = "Stegosaurus", triceratops = "Triceratops",
    tyrannosaurus = "Tyrannosaurus", velociraptor = "Velociraptor"
  };

paleotest.iceage_animals = { 
    dire_wolf = "Dire_wolf", elasmotherium = "Elasmotherium",
    mammoth = "Mammoth", procoptodon = "Procoptodon",
    smilodon = "Smilodon", thylacoleo = "Thylacoleo"
  };

paleotest.water_dinosaurs = {
    dunkleosteus = "Dunkleosteus", mosasaurus = "Mosasaurus", 
    plesiosaurus = "Plesiosaurus"
  };

paleotest.hades_seeds = { 
    wheat = "Wheat", cotton = "Cotton",
    spice = "Spice", potato = "Potato",
    strawberry = "Strawberry", tomato = "Tomato",
  };

paleotest.hades_sapling = { 
    common = "Apple", olive = "Olive",
    pale = "Pale", birch = "Birch",
    jungle = "Jungle", cjtree = "Cultivated Jungle",
    banana = "Banana", orange = "Orange",
    cocoa = "Cocoa", coconut = "Coconut",
  };

paleotest.hades_extra_seeds = { 
    carrot = "Carrot", cucumber = "Cucumber",
    corn = "Corn", coffee = "Coffee",
    melon = "Melon", pumpkin = "Pumpkin",
    raspberry = "Raspberry",
    blueberry = "Blueberry", rhubarb = "Rhubarb",
    bean = "Bean", grapes = "Grapes",
    barley = "Barley", hemp = "Hemp",
    garlic = "Garlic", onion = "Onion",
    pepper = "Pepper", pineapple = "Pineapple",
    pea = "Pea", beetroot = "Beetroot",
    chili = "Chili", rye = "Rye",
    oat = "Oat", rice = "Rice",
    mint = "Mint", cabbage = "Cabbage",
    blackberry = "Blackberry",
    soy = "Soy", vanilla = "Vanilla",
    lettuce = "Lettuce", artichoke = "Artichoke",
    parsley = "Parsley", sunflower = "Sunflower",
  };

local hades_cool_sapling = { 
    baldcypress = "Baldcypress", bamboo = "Bamboo",
    birch = "Birch", cherrytree = "Cherry tree",
    chestnuttree = "Chestnut tree", clementinetree = "Clementine tree",
    ebony = "Ebony", hollytree = "Holly tree",
    jacaranda = "Jacaranda", larch = "Larch",
    lemontree = "Lemon tree", mahogany = "Mahogany",
    maple = "Maple", oak = "Oak",
    palm = "Palm", pineapple = "Pineapple",
    plumtree = "Plum tree", pomegranate = "Pomegranate",
    willow = "Willow", cacaotree = "Cacao tree",
    sequoia = "Sequoia",
  };
for sapling, name in pairs(hades_cool_sapling) do
  if minetest.get_modpath("hades_"..sapling) then
    if (not paleotest.hades_cool_sapling) then 
      paleotest.hades_cool_sapling = {};
    end
    paleotest.hades_cool_sapling[sapling] = name;
  end
end

paleotest.hades_technic_sapling = { 
    rubber_tree = "Rubber tree",
  };

paleotest.hades_xocean_sapling = { 
    coral_pink = "Brain coral",
    coral_cyan = "Tube coral",
    bubble = "Bubble coral",
    horn = "Horn coral",
    fire = "Fire coral",
    sand_with_kelp = "Kelp",
    seagrass = "Seagrass",
    pickle = "Pickle",
  };

paleotest.hades_aquaz_sapling = {
    acropora = "Acropora Coral",
    carnation = "Carnation Coral",
    fiery_red = "Fiery Red Coral",
    psammocora = "Psammocora Coral",
    rhodophyta = "Rhodophyta Coral",
    sarcophyton = "Sarcophyton Coral",
    pink_birdnest_coral = "Pink Birdnest Coral",
    aquamarine_coral = "Aquamarine Coral",
    
    grass = "Aquatic Grass",
    tall_grass = "Aquatic Tall Grass",
    sword_plant = "Aquatic Sword Plant",
    sea_cucumbers = "Cucumbers",
    calliarthron_kelp = "Calliarthron_kelp",
    red_alga = "Red Alga Remains",
    orange_alga = "Orange Alga Remains",
    purple_alga = "Purple Alga Remains",
  };

paleotest.hades_animals = {
    bee = "Bee", chicken = "Chicken", bunny = "Bunny",
    cow = "Cow", kitten = "Kitten", panda = "Panda", 
    penguin = "Penguin", pumba = "Pumba", rat = "Rat", 
    sheep = "Sheep",
  };

paleotest.hades_horse = {
    horse = "Horse",
  };

paleotest.hades_villages = {
  villager_male = "Villager Male",
  villager_female = "Villager Female",
};

paleotest.hades_fauna = {}
local function add_fauna(fauna_key, fauna_def)
  if paleotest.hades_fauna[fauna_key] then
    minetest.log("error", "[paleotest]: Fauna \""..fauna_key.."\" is already registered.");
    return;
  end
  paleotest.hades_fauna[fauna_key] = fauna_def;
end

if minetest.get_modpath("hades_petz") then
  add_fauna("petz_bat", {
    desc = "Bat",
    tt_help = "Mod hades_petz (mobkit)",
    dna_parts = 3,
    egg = "hades_petz:bat_set",
    nutrients = 5, -- 1 min, 10 g
  })
  add_fauna("petz_beaver", {
    desc = "Beaver",
    tt_help = "Mod hades_petz (mobkit)",
    dna_parts = 3,
    egg = "hades_petz:beaver_set",
    nutrients = 25, -- 4 min, 25 kg
  })
  add_fauna("petz_bunny", {
    desc = "Bunny",
    tt_help = "Mod hades_petz (mobkit)",
    dna_parts = 3,
    egg = "hades_petz:bunny_set",
    nutrients = 6, -- 1 min, 1.75 kg
  })
  add_fauna("petz_butterfly", {
    desc = "Butterfly",
    tt_help = "Mod hades_petz (mobkit)",
    dna_parts = 3,
    egg = "hades_petz:butterfly_set",
    nutrients = 4, -- 1 min, < 1 g
  })
  add_fauna("petz_calf", {
    desc = "Calf",
    tt_help = "Mod hades_petz (mobkit)",
    dna_parts = 3,
    egg = "hades_petz:calf_set",
    nutrients = 40, -- 7 min, 40 kg
  })
  add_fauna("petz_chicken", {
    desc = "Chicken",
    tt_help = "Mod hades_petz (mobkit)",
    dna_parts = 3,
    egg = "hades_petz:chicken_set",
    nutrients = 5, -- 1 min, 780 g
  })
  add_fauna("petz_chimp", {
    desc = "Chimp",
    tt_help = "Mod hades_petz (mobkit)",
    dna_parts = 3,
    egg = "hades_petz:chimp_set",
    nutrients = 50, -- 8 min, 50 kg
  })
  add_fauna("petz_clownfish", {
    desc = "Clownfish",
    tt_help = "Mod hades_petz (mobkit)",
    dna_parts = 3,
    egg = "hades_petz:clownfish_set",
    nutrients = 5, -- 1 min, 250 g
  })
  add_fauna("petz_dolphin", {
    desc = "Dolphin",
    tt_help = "Mod hades_petz (mobkit)",
    dna_parts = 3,
    egg = "hades_petz:dolphin_set",
    nutrients = 120, -- 30 min, 120 kg
  })
  add_fauna("petz_ducky", {
    desc = "Ducky",
    tt_help = "Mod hades_petz (mobkit)",
    dna_parts = 3,
    egg = "hades_petz:ducky_set",
    nutrients = 6, -- 1 min, 1.6 kg
  })
  add_fauna("petz_elephant_female", {
    desc = "Elephant Female",
    tt_help = "Mod hades_petz (mobkit)",
    dna_parts = 3,
    egg = "hades_petz:elephant_female_set",
    nutrients = 4000, -- 667 min, 4000 kg
  })
  add_fauna("petz_elephant", {
    desc = "Elephant",
    tt_help = "Mod hades_petz (mobkit)",
    dna_parts = 3,
    egg = "hades_petz:elephant_set",
    nutrients = 6000, -- 1000 min, 6000 kg
  })
  add_fauna("petz_foxy", {
    desc = "Foxy",
    tt_help = "Mod hades_petz (mobkit)",
    dna_parts = 3,
    egg = "hades_petz:foxy_set",
    nutrients = 10, -- 2 min, 10 kg
  })
  add_fauna("petz_goat", {
    desc = "Goat",
    tt_help = "Mod hades_petz (mobkit)",
    dna_parts = 3,
    egg = "hades_petz:goat_set",
    nutrients = 50, -- 8 min, 50 kg
  })
  add_fauna("petz_grizzly", {
    desc = "Grizzly",
    tt_help = "Mod hades_petz (mobkit)",
    dna_parts = 3,
    egg = "hades_petz:grizzly_set",
    nutrients = 250, -- 42 min, 250 kg
  })
  add_fauna("petz_hamster", {
    desc = "Hamster",
    tt_help = "Mod hades_petz (mobkit)",
    dna_parts = 3,
    egg = "hades_petz:hamster_set",
    nutrients = 5, -- 1 min, 5 kg
  })
  add_fauna("petz_hen", {
    desc = "Hen",
    tt_help = "Mod hades_petz (mobkit)",
    dna_parts = 3,
    egg = "hades_petz:hen_set",
    nutrients = 6, -- 1 min, 2.25 kg
  })
  add_fauna("petz_kitty", {
    desc = "Kitty",
    tt_help = "Mod hades_petz (mobkit)",
    dna_parts = 3,
    egg = "hades_petz:kitty_set",
    nutrients = 8, -- 2 min, 4 kg
  })
  add_fauna("petz_lamb", {
    desc = "Lamb",
    tt_help = "Mod hades_petz (mobkit)",
    dna_parts = 3,
    egg = "hades_petz:lamb_set",
    nutrients = 20, -- 3 min, 20 kg
  })
  add_fauna("petz_leopard", {
    desc = "Leopard",
    tt_help = "Mod hades_petz (mobkit)",
    dna_parts = 3,
    egg = "hades_petz:leopard_set",
    nutrients = 31, -- 5 min, 31 kg
  })
  add_fauna("petz_lion", {
    desc = "Lion",
    tt_help = "Mod hades_petz (mobkit)",
    dna_parts = 3,
    egg = "hades_petz:lion_set",
    nutrients = 190, -- 32 min, 190 kg
  })
  add_fauna("petz_moth", {
    desc = "Moth",
    tt_help = "Mod hades_petz (mobkit)",
    dna_parts = 3,
    egg = "hades_petz:moth_set",
    nutrients = 4, -- 40 sec, 1 < g
  })
  add_fauna("petz_mr_pumpkin", {
    desc = "Mr. Pumpkin",
    tt_help = "Mod hades_petz (mobkit)",
    dna_parts = 3,
    egg = "hades_petz:mr_pumpkin_set",
    nutrients = 80, -- 13 min, 80 kg
  })
  add_fauna("petz_panda", {
    desc = "Panda",
    tt_help = "Mod hades_petz (mobkit)",
    dna_parts = 3,
    egg = "hades_petz:panda_set",
    nutrients = 110, -- 19 min, 110 kg
  })
  add_fauna("petz_parrolt", {
    desc = "Parrolt",
    tt_help = "Mod hades_petz (mobkit)",
    dna_parts = 3,
    egg = "hades_petz:parrolt_set",
    nutrients = 5, -- 1 min, 500 g
  })
  add_fauna("petz_penguin", {
    desc = "Penguin",
    tt_help = "Mod hades_petz (mobkit)",
    dna_parts = 3,
    egg = "hades_petz:penguin_set",
    nutrients = 23, -- 4 min, 23 kg
  })
  add_fauna("petz_pigeon", {
    desc = "Pigeon",
    tt_help = "Mod hades_petz (mobkit)",
    dna_parts = 3,
    egg = "hades_petz:pigeon_set",
    nutrients = 5, -- 1 min, 300 g
  })
  add_fauna("petz_piggy", {
    desc = "Piggy",
    tt_help = "Mod hades_petz (mobkit)",
    dna_parts = 3,
    egg = "hades_petz:piggy_set",
    nutrients = 75, -- 13 min, 75 kg
  })
  add_fauna("petz_polar_bear", {
    desc = "Polar Bear",
    tt_help = "Mod hades_petz (mobkit)",
    dna_parts = 3,
    egg = "hades_petz:polar_bear_set",
    nutrients = 450, -- 75 min, 450 kg
  })
  add_fauna("petz_pony", {
    desc = "Pony",
    tt_help = "Mod hades_petz (mobkit)",
    dna_parts = 3,
    egg = "hades_petz:pony_set",
    nutrients = 360, -- 60 min, 360 kg
  })
  --[[
  add_fauna("petz_puppy", {
    desc = "Puppy",
    tt_help = "Mod hades_petz (mobkit)",
    dna_parts = 3,
    egg = "hades_petz:puppy_set",
    nutrients = 8, -- 2 min, 5 kg
  })--]]
  add_fauna("petz_queen_ant", {
    desc = "Queen Ant",
    tt_help = "Mod hades_petz (mobkit)",
    dna_parts = 3,
    egg = "hades_petz:queen_ant_set",
    nutrients = 4, -- 40 sec, < 1 g
  })
  add_fauna("petz_queen_bee", {
    desc = "Queen Bee",
    tt_help = "Mod hades_petz (mobkit)",
    dna_parts = 3,
    egg = "hades_petz:queen_bee_set",
    nutrients = 4, -- 40 sec, < 1 g
  })
  add_fauna("petz_rat", {
    desc = "Rat",
    tt_help = "Mod hades_petz (mobkit)",
    dna_parts = 3,
    egg = "hades_petz:rat_set",
    nutrients = 5, -- 1 min, 150 g
  })
  add_fauna("petz_rooster", {
    desc = "Rooster",
    tt_help = "Mod hades_petz (mobkit)",
    dna_parts = 3,
    egg = "hades_petz:rooster_set",
    nutrients = 7, -- 1 min, 3 kg
  })
  add_fauna("petz_silkworm", {
    desc = "Silkworm",
    tt_help = "Mod hades_petz (mobkit)",
    dna_parts = 3,
    egg = "hades_petz:silkworm_set",
    nutrients = 4, -- 1 min, < 1 g
  })
  add_fauna("petz_snow_leopard", {
    desc = "Snow Leopard",
    tt_help = "Mod hades_petz (mobkit)",
    dna_parts = 3,
    egg = "hades_petz:snow_leopard_set",
    nutrients = 50, -- 8 min, 50 kg
  })
  add_fauna("petz_squirrel", {
    desc = "Squirrel",
    tt_help = "Mod hades_petz (mobkit)",
    dna_parts = 3,
    egg = "hades_petz:squirrel_set",
    nutrients = 5, -- 1 min, 330 g
  })
  add_fauna("petz_tarantula", {
    desc = "Tarantula",
    tt_help = "Mod hades_petz (mobkit)",
    dna_parts = 3,
    egg = "hades_petz:tarantula_set",
    nutrients = 5, -- 1 min, ? g
  })
  add_fauna("petz_toucan", {
    desc = "Toucan",
    tt_help = "Mod hades_petz (mobkit)",
    dna_parts = 3,
    egg = "hades_petz:toucan_set",
    nutrients = 5, -- 1 min, 500 g
  })
  add_fauna("petz_tropicalfish", {
    desc = "Tropical Fish",
    tt_help = "Mod hades_petz (mobkit)",
    dna_parts = 3,
    egg = "hades_petz:tropicalfish_set",
    nutrients = 15, -- 3 min, 15 kg
  })
  add_fauna("petz_turtle", {
    desc = "Turtle",
    tt_help = "Mod hades_petz (mobkit)",
    dna_parts = 3,
    egg = "hades_petz:turtle_set",
    nutrients = 400, -- 67 min, 400 kg
  })
  add_fauna("petz_werewolf", {
    desc = "Werewolf",
    tt_help = "Mod hades_petz (mobkit)",
    dna_parts = 3,
    egg = "hades_petz:werewolf_set",
    nutrients = 10000, -- 1667 min, ? kg
  })
  add_fauna("petz_wolf", {
    desc = "Wolf",
    tt_help = "Mod hades_petz (mobkit)",
    dna_parts = 3,
    egg = "hades_petz:wolf_set",
    nutrients = 50, -- 8 min, 50 kg
  })
end

if minetest.get_modpath("hades_animalia") then
  add_fauna("animalia_cat", {
    desc = "Cat",
    tt_help = "Mod hades_animalia (mobkit)",
    dna_parts = 3,
    egg = "hades_animalia:cat",
    nutrients = 8, -- 2 min, 4 kg
  })
  add_fauna("animalia_chicken", {
    desc = "Chicken",
    tt_help = "Mod hades_animalia (mobkit)",
    dna_parts = 3,
    egg = "hades_animalia:chicken",
    nutrients = 5, -- 1 min, 780 g
  })
  add_fauna("animalia_cow", {
    desc = "Cow",
    tt_help = "Mod hades_animalia (mobkit)",
    dna_parts = 3,
    egg = "hades_animalia:cow",
    nutrients = 750, -- 152 min, 75 kg
  })
  add_fauna("animalia_horse", {
    desc = "Horse",
    tt_help = "Mod hades_animalia (mobkit)",
    dna_parts = 3,
    egg = "hades_animalia:horse",
    nutrients = 690, -- 115 min, 690 kg
  })
  add_fauna("animalia_pig", {
    desc = "Pig",
    tt_help = "Mod hades_animalia (mobkit)",
    dna_parts = 3,
    egg = "hades_animalia:pig",
    nutrients = 250, -- 42 min, 250 kg
  })
  add_fauna("animalia_sheep", {
    desc = "Sheep",
    tt_help = "Mod hades_animalia (mobkit)",
    dna_parts = 3,
    egg = "hades_animalia:sheep",
    nutrients = 100, -- 17 min, 100 kg
  })
  add_fauna("animalia_turkey", {
    desc = "Turkey",
    tt_help = "Mod hades_animalia (mobkit)",
    dna_parts = 3,
    egg = "hades_animalia:turkey",
    nutrients = 10, -- 2 min, 10 kg
  })
  add_fauna("animalia_wolf", {
    desc = "Wolf",
    tt_help = "Mod hades_animalia (mobkit)",
    dna_parts = 3,
    egg = "hades_animalia:wolf",
    nutrients = 50, -- 8 min, 50 kg
  })
end

if minetest.get_modpath("hades_xocean") then
  add_fauna("xocean_dolphin", {
    desc = "Dolphin",
    tt_help = "Mod hades_xocean (mobs)",
    dna_parts = 3,
    egg = "hades_xocean:dolphin",
    nutrients = 120, -- 30 min, 120 kg
  })
  add_fauna("xocean_fish", {
    desc = "Tropical Fish (Kob)",
    tt_help = "Mod hades_xocean (mobs)",
    dna_parts = 3,
    egg = "hades_xocean:fish",
    nutrients = 41, -- x min, 41 kg
  })
  add_fauna("xocean_fish2", {
    desc = "Tropical Fish (SunStreak)",
    tt_help = "Mod hades_xocean (mobs)",
    dna_parts = 3,
    egg = "hades_xocean:fish2",
    nutrients = 20, -- 3 min, 20 kg
  })
  add_fauna("xocean_fish3", {
    desc = "Tropical Fish (Dasher)",
    tt_help = "Mod hades_xocean (mobs)",
    dna_parts = 3,
    egg = "hades_xocean:fish3",
    nutrients = 20, -- 3 min, 20 kg
  })
  add_fauna("xocean_fish4", {
    desc = "Tropical Fish (Snapper)",
    tt_help = "Mod hades_xocean (mobs)",
    dna_parts = 3,
    egg = "hades_xocean:fish4",
    nutrients = 13, -- 2 min, 13 kg
  })
end

if minetest.get_modpath("hades_bat") then
  add_fauna("bat", {
    desc = "Bat",
    tt_help = "Mod hades_bat (mobs)",
    dna_parts = 3,
    egg = "hades_bat:bat",
    nutrients = 5, -- 1 min, 10 g
  })
end
if minetest.get_modpath("hades_bear") then
  add_fauna("bear", {
    desc = "Bear",
    tt_help = "Mod hades_bear (mobs)",
    dna_parts = 3,
    egg = "hades_bear:medved",
    nutrients = 350, -- 58 min, 350 kg
  })
end
if minetest.get_modpath("hades_better_rat") then
  add_fauna("better_rat", {
    desc = "Rat",
    tt_help = "Mod hades_better_rat (mobs)",
    dna_parts = 3,
    egg = "hades_better_rat:rat",
    nutrients = 4, -- 1 min, 150 g
  })
end
if minetest.get_modpath("hades_birds") then
  add_fauna("gull", {
    desc = "Gull",
    tt_help = "Mod hades_birds (mobs)",
    dna_parts = 3,
    egg = "hades_birds:gull",
    nutrients = 6, -- 1 min, 1.1 kg
  })
  add_fauna("bird_lg", {
    desc = "Large Bird",
    tt_help = "Mod hades_birds (mobs)",
    dna_parts = 3,
    egg = "hades_birds:bird_lg",
    nutrients = 10, -- 2 min, 10 kg
  })
  add_fauna("bird_sm", {
    desc = "Small Bird",
    tt_help = "Mod hades_birds (mobs)",
    dna_parts = 3,
    egg = "hades_birds:bird_sm",
    nutrients = 7, -- 1 min, 3 kg
  })
end
if minetest.get_modpath("hades_bugslive") then
  add_fauna("bugslive", {
    desc = "Bug",
    tt_help = "Mod hades_bugslive (mobs)",
    dna_parts = 3,
    egg = "hades_buslive:bug",
    nutrients = 4, -- 1 min, < 100 g
  })
end
if minetest.get_modpath("hades_butterfly") then
  add_fauna("buttefly", {
    desc = "Butterfly",
    tt_help = "Mod hades_ (mobs)",
    dna_parts = 3,
    egg = "hades_butterfly:butterfly",
    nutrients = 4, -- 1 min, < 100 g
  })
end
if minetest.get_modpath("hades_deer") then
  add_fauna("deer", {
    desc = "Deer",
    tt_help = "Mod hades_deer (mobs)",
    dna_parts = 3,
    egg = "hades_deer:deer",
    nutrients = 200, -- 33 min, 200 kg
  })
end
if minetest.get_modpath("hades_doomed") then
  add_fauna("fox", {
    desc = "Fox",
    tt_help = "Mod hades_doomed (mobs)",
    dna_parts = 3,
    egg = "hades_doomed:fox",
    nutrients = 10, -- 2 min, 10 kg
  })
  add_fauna("whale", {
    desc = "Whale",
    tt_help = "Mod hades_doomed (mobs)",
    dna_parts = 3,
    egg = "hades_doomed:whale",
    nutrients = 10000, -- 1667 min, 10000 kg
  })
  add_fauna("hedgehog", {
    desc = "Hedgehog",
    tt_help = "Mod hades_doomed (mobs)",
    dna_parts = 3,
    egg = "hades_doomed:hedgehog",
    nutrients = 6, -- 1 min, 1 kg
  })
  add_fauna("owl", {
    desc = "Owl",
    tt_help = "Mod hades_doomed (mobs)",
    dna_parts = 3,
    egg = "hades_doomed:owl",
    nutrients = 6, -- 1 min, 1.5 kg
  })
  --[[
  add_fauna("golem_friendly", {
    desc = "Friendly Stone Golem",
    tt_help = "Mod hades_doomed (mobs)",
    dna_parts = 3,
    egg = "hades_doomed:",
    nutrients = , -- x min, x kg
  })--]]
  add_fauna("tortoise", {
    desc = "Tortoise",
    tt_help = "Mod hades_doomed (mobs)",
    dna_parts = 3,
    egg = "hades_doomed:tortoise",
    nutrients = 200, -- 33 min, 200 kg
  })
  add_fauna("elephant", {
    desc = "Elephant",
    tt_help = "Mod hades_doomed (mobs)",
    dna_parts = 3,
    egg = "hades_doomed:elephant",
    nutrients = 6000, -- 1000 min, 6000 kg
  })
  add_fauna("badger", {
    desc = "Badger",
    tt_help = "Mod hades_doomed (mobs)",
    dna_parts = 3,
    egg = "hades_doomed:badger",
    nutrients = 15, -- 2 min, 15 kg
  })
end

if minetest.get_modpath("hades_fish") then
  add_fauna("clowfish", {
    desc = "Clowfish",
    tt_help = "Mod hades_fish (mobs)",
    dna_parts = 3,
    egg = "hades_fish:clowfish",
    nutrients = 5, -- 1 min, 250 g
  })
  add_fauna("tropical", {
    desc = "Tropical Fish",
    tt_help = "Mod hades_fish (mobs)",
    dna_parts = 3,
    egg = "hades_fish:tropical",
    nutrients = 15, -- 3 min, 15 kg
  })
end
if minetest.get_modpath("hades_giraffe") then
  add_fauna("giraffe", {
    desc = "Giraffe",
    tt_help = "Mod hades_giraffe (mobs)",
    dna_parts = 3,
    egg = "hades_giraffe:jeraf",
    nutrients = 1000, -- 167 min, 1000 kg
  })
end
if minetest.get_modpath("hades_jellyfish") then
  add_fauna("jellyfish", {
    desc = "Jellyfish",
    tt_help = "Mod hades_jellyfish (mobs)",
    dna_parts = 3,
    egg = "hades_jellyfish:jellyfish",
    nutrients = 50, -- 8 min, 50 kg
  })
end
if minetest.get_modpath("hades_mr_goat") then
  add_fauna("mr_goat", {
    desc = "Goat",
    tt_help = "Mod hades_mr_goat (mobs)",
    dna_parts = 3,
    egg = "hades_mr_goat:goat",
    nutrients = 50, -- 8 min, 50 kg
  })
end
if minetest.get_modpath("hades_turtules") then
  add_fauna("turtle", {
    desc = "Turtle",
    tt_help = "Mod hades_turtules (mobs)",
    dna_parts = 3,
    egg = "hades_turtules:turtle",
    nutrients = 200, -- 33 min, 200 kg
  })
  add_fauna("seaturtle", {
    desc = "Sea Turtle",
    tt_help = "Mod hades_turtules (mobs)",
    dna_parts = 3,
    egg = "hades_turtules:seatutle",
    nutrients = 400, -- 67 min, 400 kg
  })
end
if minetest.get_modpath("hades_walrus") then
  add_fauna("walrus", {
    desc = "Walrus",
    tt_help = "Mod hades_alrus (mobs)",
    dna_parts = 3,
    egg = "hades_walrus:walrus",
    nutrients = 1000, -- 167 min, 1000 kg
  })
end
if minetest.get_modpath("hades_wolf") then
  add_fauna("wolf", {
    desc = "Wolf",
    tt_help = "Mod hades_wolf (mobs)",
    dna_parts = 3,
    egg = "hades_wolf:wolf",
    nutrients = 50, -- 8 min, 50 kg
  })
  --[[
  add_fauna("dog", {
    desc = "Dog",
    tt_help = "Mod hades_wolf (mobs)",
    dna_parts = 3,
    egg = "hades_wolf:dog",
    nutrients = 25, -- 4 min, 25 kg
  })
  --]]
end
--[[
if minetest.get_modpath("hades_") then
  add_fauna("", {
    desc = "",
    tt_help = "Mod hades_ (mobs)",
    dna_parts = ,
    egg = "hades_:",
    nutrients = , -- x min, x kg
  })
end
--]]

minetest.register_alias("default:diamond", "hades_core:diamond");
minetest.register_alias("hades_trees:common_sapling", "hades_trees:sapling");
minetest.register_alias("hades_trees:cjtree_sapling", "hades_trees:cultivated_jungle_sapling");
minetest.register_alias("bamboo:sapling", "bamboo:sprout");
minetest.register_alias("hades_technic_worldgen:rubber_tree_sapling", "moretrees:rubber_tree_sapling");
minetest.register_alias("hades_extrafarming:seed_pepper", "hades_extrafarming:peppercorn");

--
-- Fence registration helper
--
local fence_collision_extra = minetest.settings:get_bool("enable_fence_tall") and 3/8 or 0

function paleotest.register_fence_rail(name, def)
 minetest.register_craft({
  output = name .. " 16",
  recipe = {
   { def.material, def.material },
   { "", ""},
   { def.material, def.material },
  }
 })

 local fence_rail_texture = "paleotest_fence_rail_overlay.png^" .. def.texture ..
   "^paleotest_fence_rail_overlay.png^[makealpha:255,126,126"
 -- Allow almost everything to be overridden
 local default_fields = {
  paramtype = "light",
  drawtype = "nodebox",
  node_box = {
   type = "connected",
   fixed = {{-1/16,  3/16, -1/16, 1/16,  5/16, 1/16},
     {-1/16, -3/16, -1/16, 1/16, -5/16, 1/16}},
   -- connect_top =
   -- connect_bottom =
   connect_front = {{-1/16,  3/16, -1/2,   1/16,  5/16, -1/16},
             {-1/16, -5/16, -1/2,   1/16, -3/16, -1/16}},
   connect_left =  {{-1/2,   3/16, -1/16, -1/16,  5/16,  1/16},
             {-1/2,  -5/16, -1/16, -1/16, -3/16,  1/16}},
   connect_back =  {{-1/16,  3/16,  1/16,  1/16,  5/16,  1/2 },
             {-1/16, -5/16,  1/16,  1/16, -3/16,  1/2 }},
   connect_right = {{ 1/16,  3/16, -1/16,  1/2,   5/16,  1/16},
                           { 1/16, -5/16, -1/16,  1/2,  -3/16,  1/16}}
  },
  collision_box = {
   type = "connected",
   fixed = {-1/8, -1/2, -1/8, 1/8, 1/2 + fence_collision_extra, 1/8},
   -- connect_top =
   -- connect_bottom =
   connect_front = {-1/8, -1/2, -1/2,  1/8, 1/2 + fence_collision_extra, -1/8},
   connect_left =  {-1/2, -1/2, -1/8, -1/8, 1/2 + fence_collision_extra,  1/8},
   connect_back =  {-1/8, -1/2,  1/8,  1/8, 1/2 + fence_collision_extra,  1/2},
   connect_right = { 1/8, -1/2, -1/8,  1/2, 1/2 + fence_collision_extra,  1/8}
  },
  connects_to = {"group:fence", "group:wall"},
  inventory_image = fence_rail_texture,
  wield_image = fence_rail_texture,
  tiles = {def.texture},
  sunlight_propagates = true,
  is_ground_content = false,
  groups = {},
 }
 for k, v in pairs(default_fields) do
  if def[k] == nil then
   def[k] = v
  end
 end

 -- Always add to the fence group, even if no group provided
 def.groups.fence = 1

 def.texture = nil
 def.material = nil

 minetest.register_node(name, def)
end

