---------------------
-- Embryo Incubator --
----------------------
------ Ver 2.0 -------
-----------------------
-- Initial Functions --
-----------------------

-- Added primary for Hades Revisited by SFENCE
local S = paleotest.translator;

paleotest.embryo_incubator = appliances.appliance:new(
    {
      node_name_inactive = "hades_paleotest:embryo_incubator",
      node_name_active = "hades_paleotest:embryo_incubator_active",
      
      node_description = S("Embryo incubator"),
      node_help = S("Connect to power 400 (LV) and water").."\n"..S("Keep process running").."\n"..S("Allow embryos to grow like in uterus.").."\n"..S("Use nutrients to support embryos grow. Depends on animal size.").."\n"..S("Etc one nutrient per kilogram for bigger animals (from 32kg). Small animals (to 32kg) have lower effectivity."),
      
      output_stack_size = 2,
      
      need_water = true,
      
      stoppable_production = false,
      stoppable_consumption = false,
      
      power_data = {
        ["LV"] = {
            demand = 400,
            run_speed = 1,
          },
        ["no_technic"] = {
            run_speed = 1,
          },
      },
    })

local embryo_incubator = paleotest.embryo_incubator

--------------
-- Formspec --
--------------

function embryo_incubator:get_formspec(meta, production_percent, consumption_percent)
  local progress = "image[3.6,0.5;5.5,0.95;appliances_production_progress_bar.png^[transformR270]]";
  if production_percent then
    progress = "image[3.6,0.5;5.5,0.95;appliances_production_progress_bar.png^[lowpart:" ..
            (production_percent) ..
            ":appliances_production_progress_bar_full.png^[transformR270]]";
  end
  if consumption_percent then
    progress = progress.."image[3.6,1.35;5.5,0.95;appliances_consumption_progress_bar.png^[lowpart:" ..
            (consumption_percent) ..
            ":appliances_consumption_progress_bar_full.png^[transformR270]]";
  else
    progress = progress.."image[3.6,1.35;5.5,0.95;appliances_consumption_progress_bar.png^[transformR270]]";
  end
  
  local formspec =  "formspec_version[3]" .. "size[12.75,8.5]" ..
                    "background[-1.25,-1.25;15,10;paleotest_machine_formspec.png]" ..
                    progress..
                    "list[current_player;main;1.5,3;8,4;]" ..
                    "list[context;"..self.input_stack..";2,0.25;1,1;]" ..
                    "list[context;"..self.use_stack..";2,1.5;1,1;]" ..
                    "list[context;"..self.output_stack..";9.75,0.25;1,2;]" ..
                    "listring[current_player;main]" ..
                    "listring[context;"..self.input_stack.."]" ..
                    "listring[current_player;main]" ..
                    "listring[context;"..self.use_stack.."]" ..
                    "listring[current_player;main]"..
                    "listring[context;"..self.output_stack.."]" ..
                    "listring[current_player;main]";
  return formspec;
end

----------
-- Node --
----------

local node_def = {
    paramtype2 = "facedir",
    groups = {cracky = 2},
    legacy_facedir_simple = true,
    is_ground_content = false,
    sounds = hades_sounds.node_sound_stone_defaults(),
    drawtype = "node",
 }

local node_inactive = {
    tiles = {
        "paleotest_embryo_incubator_top.png",
        "paleotest_embryo_incubator_bottom.png",
        "paleotest_embryo_incubator_side.png",
        "paleotest_embryo_incubator_side.png",
        "paleotest_embryo_incubator_side.png",
        "paleotest_embryo_incubator_front.png"
    },
  }

local node_active = {
    tiles = {
        "paleotest_embryo_incubator_top.png",
        "paleotest_embryo_incubator_bottom.png",
        "paleotest_embryo_incubator_side.png",
        "paleotest_embryo_incubator_side.png",
        "paleotest_embryo_incubator_side.png",
        {
          image = "paleotest_embryo_incubator_front_active.png",
          backface_culling = true,
          animation = {
            type = "vertical_frames",
            aspect_w = 16,
            aspect_h = 16,
            length = 1.5
          }
        }
    },
  }

embryo_incubator:register_nodes(node_def, node_inactive, node_active)

-------------------------
-- Recipe Registration --
-------------------------

embryo_incubator:recipe_register_usage(
  "hades_paleotest:nutrients",
  {
    outputs = {"vessels:steel_bottle"},
    consumption_time = 10,
    production_step_size = 1,
  });

-- etc one nutrient for 1kg from 32kg size.
-- down limit is 4 nutrients per animal.
-- animal lower then 32kg, use 4+((28/32)*mass)


-- Animal Embryos --
local function register_recipe(input, output, time)
    embryo_incubator.recipes[input] = {output=output,time=time*10}
  embryo_incubator:recipe_register_input(
    input,
    {
      inputs = 1,
      outputs = {output},
      production_time = time*10,
      consumption_step_size = 1,
    });
end
if minetest.get_modpath("hades_animals") then
  register_recipe("hades_paleotest:embryo_bee", -- 0.2 g
                  "hades_animals:bee", 4) -- 40 s
  register_recipe("hades_paleotest:embryo_chicken", -- 780 g
                  "hades_animals:chicken", 5) -- 1 min
  register_recipe("hades_paleotest:embryo_bunny", -- 1.75 kg
                  "hades_animals:bunny", 6) -- 1 min
  register_recipe("hades_paleotest:embryo_cow", -- 750 kg
                  "hades_animals:cow", 750) -- 125 min
  register_recipe("hades_paleotest:embryo_kitten", -- 4 kg
                  "hades_animals:kitten", 8) -- 2 min
  register_recipe("hades_paleotest:embryo_panda", -- 110 kg
                  "hades_animals:panda", 110) -- 19 min
  register_recipe("hades_paleotest:embryo_penguin", -- 23 kg
                  "hades_animals:penguin", 24) -- 4 min
  register_recipe("hades_paleotest:embryo_pumba", -- 90 kg
                  "hades_animals:pumba", 90) -- 15 min
  register_recipe("hades_paleotest:embryo_rat", -- 150 g
                  "hades_animals:rat", 4) -- 1 min
  register_recipe("hades_paleotest:embryo_sheep", -- 100 kg
                  "hades_animals:sheep_white", 100) -- 17 min
end
if minetest.get_modpath("hades_horse") then
  register_recipe("hades_paleotest:embryo_horse", -- 690 kg
                  "hades_horse:horse", 690) -- 115 min
end
if minetest.get_modpath("hades_petz") then
end
if minetest.get_modpath("hades_villages") then
  -- two more nutrients because of controled brain grow 
  register_recipe("hades_paleotest:embryo_villager_male", -- 80 kg
                  "hades_villages:villager_male_egg", 160) -- 27 min
  register_recipe("hades_paleotest:embryo_villager_female", -- 80 kg
                  "hades_villages:villager_female_egg", 160) -- 27 min
end


