-----------------
-- Snow Cannon --
-----------------
------- Ver 1.0 --------
-----------------------
-- Initial Functions --
-----------------------
local S = hades_snow.translator;

hades_snow.snow_cannon = appliances.appliance:new(
    {
      node_name_inactive = "hades_snow:snow_cannon",
      node_name_active = "hades_snow:snow_cannon_active",
      
      node_description = S("Snow Cannon"),
    	node_help = S("Connect to LV/generator power (400 EU) and water pipe.").."\n"..S("Punch to turn on/off."),
      
      input_stack = 0,
      have_input = false,
      use_stack = 0,
      have_usage = false,
      
      supply_connect_sides = {"left"},
      need_supply = true,
      have_control = true,
      
      sounds = {
        running = {
          sound = "hades_snow_cannon_running",
          sound_param = {max_hear_distance = 16, gain = 1},
          repeat_timer = 0,
        },
      },
    })

local snow_cannon = hades_snow.snow_cannon

snow_cannon:power_data_register(
  {
    ["LV_power"] = {
        demand = 400,
        run_speed = 1,
        disable = {"no_power"}
      },
    ["power_generators_power"] = {
        demand = 400,
        run_speed = 1,
        disable = {"no_power"}
      },
    ["no_power"] = {
        run_speed = 1,
        disable = {}
      },
  })

snow_cannon:supply_data_register(
  {
    ["water_pipe_liquid"] = {
        run_speed = 1,
        disable = {"no_supply"}
      },
    ["no_supply"] = {
        run_speed = 1,
        disable = {}
      },
  })

snow_cannon:control_data_register(
  {
    ["punch_control"] = {
      },
  })

--------------
-- Formspec --
--------------

---------------
-- Callbacks --
---------------

function snow_cannon:cb_on_production(timer_step)
  local node = minetest.get_node(timer_step.pos)
  local dir = minetest.facedir_to_dir(node.param2)
  -- shot snow ball
  local pos = vector.add(timer_step.pos, vector.new(0,1.25,0))
  pos = vector.subtract(pos, dir)
  local snow_ball = minetest.add_entity(pos, "hades_snow:snow_ball")
  if snow_ball then
    local speed = math.random(5, 15)
    dir = vector.add(dir, vector.new(0,-math.random(25,75)/100,0))
    dir = vector.multiply(dir, -speed)
    local yaw = (math.random(60)-30)/180*math.pi
    dir = vector.rotate(dir, vector.new(0,yaw,0))
    snow_ball:set_velocity(dir)
  end
  -- effect ?
end

----------
-- Node --
----------

-- node box {x=0, y=0, z=0}
local node_box = {
  type = "fixed",
  fixed = {
    {-0.4375,-0.5,-0.4375,-0.3125,0.5,-0.3125},
    {0.3125,-0.5,-0.4375,0.4375,0.5,-0.3125},
    {-0.3125,-0.3125,-0.375,-0.25,-0.1875,-0.3125},
    {0.25,-0.3125,-0.375,0.3125,-0.1875,-0.3125},
    {-0.25,-0.25,-0.375,-0.1875,-0.125,-0.3125},
    {0.1875,-0.25,-0.375,0.25,-0.125,-0.3125},
    {-0.1875,-0.1875,-0.375,-0.125,0.375,-0.3125},
    {0.125,-0.1875,-0.375,0.1875,0.375,-0.3125},
    {-0.125,-0.125,-0.375,-0.0625,0.375,-0.3125},
    {0.0625,-0.125,-0.375,0.125,0.375,-0.3125},
    {-0.3125,-0.0625,-0.375,-0.1875,0.0,-0.3125},
    {-0.0625,-0.0625,-0.375,0.0625,0.375,-0.3125},
    {0.1875,-0.0625,-0.375,0.3125,0.0,-0.3125},
    {0.3125,-0.375,-0.3125,0.375,-0.25,-0.25},
    {-0.1875,0.0,-0.3125,0.1875,0.375,0.375},
    {-0.375,0.125,-0.3125,-0.3125,0.25,-0.25},
    {0.3125,0.125,-0.3125,0.375,0.25,-0.25},
    {-0.375,0.4375,-0.3125,-0.3125,0.5,0.4375},
    {0.3125,0.4375,-0.3125,0.375,0.5,0.4375},
    {0.3125,-0.3125,-0.25,0.375,-0.1875,-0.1875},
    {-0.375,0.1875,-0.25,-0.3125,0.3125,-0.1875},
    {0.3125,0.1875,-0.25,0.375,0.3125,-0.1875},
    {0.3125,-0.25,-0.1875,0.375,-0.125,-0.125},
    {-0.375,0.25,-0.1875,-0.3125,0.375,-0.125},
    {0.3125,0.25,-0.1875,0.375,0.375,-0.125},
    {0.3125,-0.1875,-0.125,0.375,0.125,-0.0625},
    {-0.1875,-0.125,-0.125,0.3125,0.0,-0.0625},
    {0.375,-0.125,-0.125,0.5,0.125,-0.0625},
    {0.1875,0.0,-0.125,0.3125,0.125,-0.0625},
    {-0.375,0.3125,-0.125,-0.3125,0.4375,-0.0625},
    {0.3125,0.3125,-0.125,0.375,0.4375,-0.0625},
    {-0.1875,-0.125,-0.0625,0.5,-0.0625,0.125},
    {-0.1875,-0.0625,-0.0625,-0.125,0.0,0.125},
    {0.1875,0.0625,-0.0625,0.5,0.125,0.125},
    {-0.375,0.375,-0.0625,0.375,0.4375,0.0625},
    {0.3125,-0.1875,0.0625,0.375,-0.125,0.1875},
    {-0.125,-0.0625,0.0625,0.5,0.0,0.125},
    {0.1875,0.0,0.0625,0.5,0.0625,0.125},
    {-0.375,0.3125,0.0625,-0.3125,0.4375,0.125},
    {0.3125,0.3125,0.0625,0.375,0.4375,0.125},
    {0.0,0.375,0.0625,0.0625,0.5,0.25},
    {0.3125,-0.25,0.125,0.375,-0.1875,0.25},
    {-0.375,0.25,0.125,-0.3125,0.375,0.1875},
    {0.3125,0.25,0.125,0.375,0.375,0.1875},
    {-0.0625,0.375,0.125,0.0,0.5,0.1875},
    {0.0625,0.375,0.125,0.125,0.5,0.1875},
    {0.3125,-0.3125,0.1875,0.375,-0.25,0.4375},
    {-0.375,0.1875,0.1875,-0.3125,0.3125,0.25},
    {0.3125,0.1875,0.1875,0.375,0.3125,0.25},
    {0.3125,-0.375,0.25,0.375,-0.3125,0.4375},
    {-0.375,0.125,0.25,-0.3125,0.25,0.4375},
    {0.3125,0.125,0.25,0.375,0.25,0.4375},
    {-0.4375,-0.5,0.3125,-0.3125,0.125,0.4375},
    {0.3125,-0.5,0.3125,0.4375,-0.375,0.4375},
    {0.375,-0.375,0.3125,0.4375,0.5,0.4375},
    {-0.3125,-0.3125,0.3125,-0.25,-0.1875,0.4375},
    {0.25,-0.3125,0.3125,0.3125,-0.1875,0.4375},
    {-0.25,-0.25,0.3125,-0.1875,-0.125,0.4375},
    {0.1875,-0.25,0.3125,0.25,-0.125,0.4375},
    {0.3125,-0.25,0.3125,0.375,0.125,0.4375},
    {-0.1875,-0.1875,0.3125,-0.125,-0.0625,0.4375},
    {0.125,-0.1875,0.3125,0.1875,-0.0625,0.4375},
    {-0.125,-0.125,0.3125,-0.0625,0.0,0.4375},
    {0.0625,-0.125,0.3125,0.125,0.0,0.4375},
    {-0.0625,-0.0625,0.3125,0.0625,0.0,0.4375},
    {-0.4375,0.125,0.3125,-0.375,0.5,0.4375},
    {-0.375,0.25,0.3125,-0.3125,0.4375,0.4375},
    {0.3125,0.25,0.3125,0.375,0.4375,0.4375},
    {-0.3125,0.0,0.375,0.3125,0.0625,0.4375},
    {0.0,0.0625,0.375,0.0625,0.5,0.4375},
    {-0.0625,0.0,0.4375,0.0625,0.125,0.5},
  },
}
  -- node box {x=0, y=1, z=0}
for _,data in pairs({
      {-0.0625,-0.125,-0.5,0.0625,-0.0625,-0.3125},
      {-0.125,-0.0625,-0.5,-0.0625,0.0,-0.3125},
      {0.0625,-0.0625,-0.5,0.125,0.0,-0.3125},
      {-0.1875,0.0,-0.5,-0.125,0.0625,-0.3125},
      {0.125,0.0,-0.5,0.1875,0.0625,-0.3125},
      {-0.25,0.0625,-0.5,-0.1875,0.25,-0.3125},
      {0.1875,0.0625,-0.5,0.25,0.25,-0.3125},
      {-0.1875,0.25,-0.5,-0.125,0.3125,-0.3125},
      {0.125,0.25,-0.5,0.1875,0.3125,-0.3125},
      {-0.125,0.3125,-0.5,-0.0625,0.375,-0.3125},
      {0.0625,0.3125,-0.5,0.125,0.375,-0.3125},
      {-0.0625,0.375,-0.5,0.0625,0.4375,-0.3125},
      {-0.0625,-0.1875,-0.3125,0.0625,-0.125,-0.125},
      {-0.125,-0.125,-0.3125,-0.0625,-0.0625,-0.125},
      {0.0625,-0.125,-0.3125,0.125,-0.0625,-0.125},
      {-0.1875,-0.0625,-0.3125,-0.125,0.0,-0.125},
      {0.125,-0.0625,-0.3125,0.1875,0.0,-0.125},
      {-0.25,0.0,-0.3125,-0.1875,0.1875,-0.125},
      {0.1875,0.0,-0.3125,0.25,0.1875,-0.125},
      {-0.1875,0.1875,-0.3125,-0.125,0.25,-0.125},
      {0.125,0.1875,-0.3125,0.1875,0.25,-0.125},
      {-0.125,0.25,-0.3125,-0.0625,0.3125,-0.125},
      {0.0625,0.25,-0.3125,0.125,0.3125,-0.125},
      {-0.0625,0.3125,-0.3125,0.0625,0.375,-0.125},
      {-0.0625,-0.25,-0.125,0.0625,-0.1875,0.0625},
      {-0.125,-0.1875,-0.125,-0.0625,-0.125,0.0625},
      {0.0625,-0.1875,-0.125,0.125,-0.125,0.0625},
      {-0.375,-0.125,-0.125,-0.3125,0.0625,0.0625},
      {-0.1875,-0.125,-0.125,-0.125,-0.0625,0.0625},
      {0.125,-0.125,-0.125,0.1875,-0.0625,0.125},
      {-0.25,-0.0625,-0.125,-0.1875,0.125,0.0625},
      {0.1875,-0.0625,-0.125,0.25,0.125,0.0625},
      {0.3125,-0.0625,-0.125,0.375,0.0,0.0625},
      {-0.1875,0.125,-0.125,-0.125,0.1875,0.0625},
      {0.125,0.125,-0.125,0.1875,0.1875,0.0625},
      {-0.125,0.1875,-0.125,-0.0625,0.25,0.0625},
      {0.0625,0.1875,-0.125,0.125,0.25,0.0625},
      {-0.0625,0.25,-0.125,0.0625,0.3125,0.0625},
      {-0.375,-0.5,-0.0625,-0.3125,-0.125,0.0625},
      {0.3125,-0.5,-0.0625,0.375,-0.0625,0.0625},
      {-0.4375,-0.0625,-0.0625,-0.375,0.0,0.0},
      {-0.3125,-0.0625,-0.0625,-0.25,0.0,0.0},
      {0.25,-0.0625,-0.0625,0.3125,0.0,0.0},
      {0.375,-0.0625,-0.0625,0.4375,0.0,0.0},
      {-0.1875,0.0,-0.0625,-0.125,0.0625,0.0},
      {0.125,0.0,-0.0625,0.1875,0.0625,0.0},
      {0.3125,0.0,-0.0625,0.375,0.0625,0.0625},
      {0.0,-0.5,0.0,0.0625,-0.25,0.1875},
      {-0.0625,-0.5,0.0625,0.0,-0.25,0.125},
      {0.0625,-0.5,0.0625,0.125,-0.1875,0.125},
      {-0.125,-0.25,0.0625,-0.0625,-0.1875,0.25},
      {-0.1875,-0.1875,0.0625,-0.125,-0.125,0.25},
      {-0.0625,-0.1875,0.0625,0.0625,0.25,0.125},
      {0.125,-0.1875,0.0625,0.1875,-0.125,0.25},
      {-0.25,-0.125,0.0625,-0.1875,0.0625,0.25},
      {0.1875,-0.125,0.0625,0.25,0.0625,0.25},
      {-0.1875,-0.0625,0.0625,-0.0625,0.0625,0.125},
      {0.0625,-0.0625,0.0625,0.1875,0.0625,0.125},
      {-0.1875,0.0625,0.0625,-0.125,0.125,0.25},
      {0.125,0.0625,0.0625,0.1875,0.125,0.25},
      {-0.125,0.125,0.0625,-0.0625,0.1875,0.25},
      {0.0625,0.125,0.0625,0.125,0.1875,0.25},
      {-0.0625,-0.5,0.125,0.0,-0.4375,0.1875},
      {0.0625,-0.5,0.125,0.125,-0.4375,0.1875},
      {-0.0625,-0.3125,0.125,0.0,-0.25,0.25},
      {0.0625,-0.25,0.125,0.125,-0.1875,0.25},
      {-0.0625,-0.125,0.125,0.0625,0.0,0.375},
      {-0.0625,0.1875,0.125,0.0625,0.25,0.25},
      {0.0,-0.5,0.1875,0.0625,-0.4375,0.25},
      {0.0,-0.3125,0.1875,0.0625,-0.25,0.25},
      {-0.0625,-0.1875,0.1875,0.0625,-0.125,0.3125},
      {-0.125,-0.125,0.1875,-0.0625,0.0,0.3125},
      {0.0625,-0.125,0.1875,0.125,0.0,0.3125},
      {-0.0625,0.0,0.1875,0.0625,0.0625,0.3125},
      {-0.0625,-0.375,0.25,0.0625,-0.3125,0.4375},
      {-0.125,-0.3125,0.25,-0.0625,-0.25,0.4375},
      {0.0625,-0.3125,0.25,0.125,-0.25,0.4375},
      {-0.1875,-0.25,0.25,-0.125,-0.1875,0.4375},
      {0.125,-0.25,0.25,0.1875,-0.1875,0.4375},
      {-0.25,-0.1875,0.25,-0.1875,0.0,0.4375},
      {0.1875,-0.1875,0.25,0.25,0.0,0.4375},
      {-0.1875,0.0,0.25,-0.125,0.0625,0.4375},
      {0.125,0.0,0.25,0.1875,0.0625,0.4375},
      {-0.125,0.0625,0.25,-0.0625,0.125,0.4375},
      {0.0625,0.0625,0.25,0.125,0.125,0.4375},
      {-0.0625,0.125,0.25,0.0625,0.1875,0.4375},
      {0.0,-0.4375,0.3125,0.0625,-0.375,0.4375},
      {0.0,-0.3125,0.3125,0.0625,-0.125,0.375},
      {0.0,-0.5,0.375,0.0625,-0.4375,0.4375},
      {-0.0625,-0.3125,0.4375,0.0625,0.125,0.5},
      {-0.125,-0.25,0.4375,-0.0625,0.0625,0.5},
      {0.0625,-0.25,0.4375,0.125,0.0625,0.5},
      {-0.1875,-0.1875,0.4375,-0.125,0.0,0.5},
      {0.125,-0.1875,0.4375,0.1875,0.0,0.5},
    }) do
  data[2] = data[2] + 1
  data[5] = data[5] + 1
  table.insert(node_box.fixed, data)
end

local node_def = {
    paramtype = "light",
    paramtype2 = "facedir",
    groups = {cracky = 2},
    legacy_facedir_simple = true,
    is_ground_content = false,
    sounds = hades_sounds.node_sound_metal_defaults(),
    drawtype = "mesh",
    mesh = "hades_snow_cannon.obj",
    use_texture_alpha = "blend",
    collision_box = node_box,
    selection_box = node_box,
 }

local node_inactive = {
    tiles = {
        "hades_snow_cannon_body.png",
        "hades_snow_cannon_conn.png",
        "hades_snow_cannon_body2.png",
        "hades_snow_cannon_grid.png",
    },
  }

local node_active = {
    tiles = {
        "hades_snow_cannon_body.png",
        "hades_snow_cannon_conn.png",
        "hades_snow_cannon_body2.png",
        "hades_snow_cannon_grid.png",
    },
  }

snow_cannon:register_nodes(node_def, node_inactive, node_active)

-------------------------
-- Recipe Registration --
-------------------------

--[[
appliances.register_craft_type("hades_snow_snow_cannon", {
    description = S("Composting"),
    icon = "hades_snow_hades_snow_craft_type_icon.png",
    width = 1,
    height = 1,
  })

snow_cannon:recipe_register_input(
	"",
	{
		inputs = 1,
		outputs = {"hades_snow:compost_clod"},
		consumption_time = 76,
		consumption_step_size = 1,
	});

minetest.register_on_mods_loaded(
    function ()
      snow_cannon:register_recipes("hades_snow_snow_cannon", "hades_snow_snow_cannon_usage")
    end
  )
--]]

