
local ent_name, ent = harder_fight.get_entity({"boats:boat"})

if ent then
	local old_on_punch = ent.on_punch

	ent.on_punch = function(self, puncher, time_from_punch, tool_caps, dir, damage)
		dir = vector.normalize(dir)
		local angle = math.deg(math.acos(dir.y))
		--print("Boat punch from angle: "..angle.." dir: "..dir.y)
		local redirect = true
		if angle < 50 then
			redirect = false
		elseif angle < 90 then
			local chance = ((angle - 50) / (90 - 50))
			--print("chance "..chance)
			if math.random() > chance then
				redirect = false
			end
		end
		if redirect then
			local childs = self.object:get_children()
			if childs[1] then
				if childs[1]:get_player_name() ~= puncher:get_player_name() then
					--print("redirected")
					childs[1]:punch(puncher, time_from_punch, tool_caps, dir)
					return
				end
			end
		end
		old_on_punch(self, puncher, time_from_punch, tool_caps, dir, damage)
	end

	core.log("action", "Mod harder_fight modified entity "..ent_name)
end
