-- Helper entities for hitboxes_lib

-- Hitbox visualizer entity for debugging
core.register_entity("hitboxes_lib:hitbox_visualizer", {
	initial_properties = {
		visual = "cube",
		visual_size = {x = 1, y = 1, z = 1},
		textures = {
			"hitboxes_lib_hitbox_debug.png",
			"hitboxes_lib_hitbox_debug.png",
			"hitboxes_lib_hitbox_debug.png",
			"hitboxes_lib_hitbox_debug.png",
			"hitboxes_lib_hitbox_debug.png",
			"hitboxes_lib_hitbox_debug.png",
		},
		physical = false,
		collide_with_objects = false,
		pointable = false,
		static_save = false,
		use_texture_alpha = true,
		glow = 5,
	},
	
	lifetime = 5,
	box_name = "",
	attached_to = nil,
	
	on_activate = function(self, staticdata)
		self.timer = 0
	end,
	
	on_step = function(self, dtime)
		self.timer = self.timer + dtime
		
		-- Remove if lifetime expired or attached object is gone
		if self.timer >= self.lifetime then
			self.object:remove()
			return
		end
		
		if self.attached_to and not self.attached_to:get_pos() then
			self.object:remove()
			return
		end
	end,
})
